/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.jaxor.MetaField;
import net.sourceforge.jaxor.MetaParser;
import net.sourceforge.jaxor.util.SystemException;
import net.sourceforge.jaxor.util.Validation;

public class MetaRow
implements Serializable {
    private final List _list = new ArrayList();
    private final String _table;
    private MetaParser _parser;
    private Class _implClass;
    private Class _listImpl;

    public MetaRow(String table, Class impl, Class listImpl) {
        this._table = table;
        this._implClass = impl;
        this._listImpl = listImpl;
    }

    public Class getImplClass() {
        return this._implClass;
    }

    public Class getListImplClass() {
        return this._listImpl;
    }

    public void setImplClass(Class implClass) {
        this._implClass = implClass;
    }

    public void add(MetaField field) {
        this._list.add(field);
        this._parser = null;
    }

    public String getTableName() {
        return this._table;
    }

    public Validation validateColumns(Connection conn, boolean capitalizeTable) {
        return this.findInvalidColumns(conn, capitalizeTable);
    }

    private Validation findInvalidColumns(Connection conn, boolean capitalizeTable) {
        try {
            Validation val = new Validation();
            DatabaseMetaData meta = conn.getMetaData();
            Set allColumns = this.getColumnNamesInUpperCase();
            String tableName = capitalizeTable ? this.getTableName().toUpperCase() : this.getTableName();
            ResultSet set = meta.getColumns(null, null, tableName, "%");
            while (set.next()) {
                String msg;
                String columnName = set.getString("COLUMN_NAME");
                if (!allColumns.remove(columnName.toUpperCase())) {
                    val.addInfo("Table " + tableName + " Contains Column: " + columnName + " not found in SQLGEN");
                    continue;
                }
                boolean nullable = "YES".equals(set.getString("IS_NULLABLE"));
                MetaField field = this.findMetaByColumn(columnName);
                if (!nullable && field.canBeNull()) {
                    msg = " Jaxor nullable=" + field.canBeNull() + " database nullable=" + nullable;
                    val.addError("Table: " + tableName + " Column: " + columnName + msg);
                    continue;
                }
                if (!nullable || nullable == field.canBeNull()) continue;
                msg = " Jaxor nullable=" + field.canBeNull() + " database nullable=" + nullable;
                val.addInfo("Table: " + tableName + " Column: " + columnName + msg);
            }
            set.close();
            Iterator iterator = allColumns.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                val.addError(s + " column defined in " + tableName + "Entity not found in database");
            }
            return val;
        }
        catch (SQLException e) {
            throw new SystemException("Failed to find Columns for table: " + this.getTableName(), (Throwable)e);
        }
    }

    public MetaField findMetaByColumn(String columnName) {
        Iterator iterator = this._list.iterator();
        while (iterator.hasNext()) {
            MetaField metaField = (MetaField)iterator.next();
            if (!metaField.getColumn().equalsIgnoreCase(columnName)) continue;
            return metaField;
        }
        return null;
    }

    private Set getColumnNamesInUpperCase() {
        HashSet<String> set = new HashSet<String>();
        Iterator iterator = this._list.iterator();
        while (iterator.hasNext()) {
            MetaField metaField = (MetaField)iterator.next();
            set.add(metaField.getColumn().toUpperCase());
        }
        return set;
    }

    public List getColumns() {
        return Collections.unmodifiableList(this._list);
    }

    public List getPrimaryKey() {
        ArrayList<MetaField> key = new ArrayList<MetaField>();
        int i = 0;
        while (i < this._list.size()) {
            MetaField field = (MetaField)this._list.get(i);
            if (field.isPrimaryKey()) {
                key.add(field);
            }
            ++i;
        }
        return key;
    }

    public List getInsertColumns() {
        ArrayList<MetaField> insert = new ArrayList<MetaField>();
        Iterator iter = this._list.iterator();
        while (iter.hasNext()) {
            MetaField element = (MetaField)iter.next();
            if (element.isAutoAssign()) continue;
            insert.add(element);
        }
        return insert;
    }

    public List getUpdateColumns() {
        ArrayList<MetaField> all = new ArrayList<MetaField>();
        Iterator iterator = this._list.iterator();
        while (iterator.hasNext()) {
            MetaField attribute = (MetaField)iterator.next();
            if (attribute.isPrimaryKey()) continue;
            all.add(attribute);
        }
        return all;
    }

    public List getUpdateMatchColumns() {
        ArrayList<MetaField> all = new ArrayList<MetaField>();
        Iterator iterator = this._list.iterator();
        while (iterator.hasNext()) {
            MetaField attribute = (MetaField)iterator.next();
            if (!attribute.isMatchOnUpdate()) continue;
            all.add(attribute);
        }
        return all;
    }

    public MetaParser getParser() {
        if (this._parser == null) {
            this._parser = new MetaParser(this);
        }
        return this._parser;
    }

    public List getNonPrimaryKeyColumns() {
        ArrayList<MetaField> results = new ArrayList<MetaField>();
        Iterator iterator = this._list.iterator();
        while (iterator.hasNext()) {
            MetaField metaField = (MetaField)iterator.next();
            if (metaField.isPrimaryKey()) continue;
            results.add(metaField);
        }
        return results;
    }
}

