/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jaxor.parser.Attribute;
import net.sourceforge.jaxor.parser.EntityCollection;
import net.sourceforge.jaxor.parser.Jaxor;
import net.sourceforge.jaxor.parser.Key;

public class EntityRef {
    private String _entity;
    private String _query;
    private String _find;
    private String _alias;
    private List _keys = new ArrayList();

    public void setTable(String entity) {
        this._entity = entity;
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public String getTable() {
        return this._entity;
    }

    public void addKey(Key k) {
        this._keys.add(k);
    }

    public String getQuery() {
        return this._query;
    }

    public void setFind(String find) {
        this._find = find;
    }

    public void setQuery(String query) {
        this._query = query;
    }

    private String getQueryAsArg() {
        if (this._query == null) {
            return "null";
        }
        return "\"" + this._query + "\"";
    }

    private String getFindAsArg() {
        if (this._find == null) {
            return "null";
        }
        return "\"" + this._find + "\"";
    }

    public boolean isUnique() {
        return true;
    }

    public List getRefKeys(Jaxor source, EntityCollection coll) {
        ArrayList<String> results = new ArrayList<String>();
        Jaxor target = coll.resolveEntity(this._entity);
        Iterator iterator = this._keys.iterator();
        while (iterator.hasNext()) {
            Key key = (Key)iterator.next();
            Attribute att = source.findAttribute(key.getSource());
            Attribute targetAtt = target.findAttribute(key.getTarget());
            String sourceMeta = "new " + source.getPackageName() + "." + source.getEntity().getMetaName() + "().get" + att.getJavaName() + "()";
            String targetMeta = "new " + target.getPackageName() + "." + target.getEntity().getMetaName() + "().get" + targetAtt.getJavaName() + "()";
            results.add(this.getName(coll) + ".getResolver().add(" + sourceMeta + "," + targetMeta + ");\n");
        }
        return results;
    }

    public String getResolverConstructor(EntityCollection col, Jaxor source) {
        Jaxor target = col.resolveEntity(this._entity);
        String finder = target.getFinderImplFull();
        String method = this.getResolverConstructor(finder);
        return method;
    }

    public String getType(EntityCollection col) {
        Jaxor target = col.resolveEntity(this._entity);
        return target.getEntityClassFull();
    }

    public String getName(EntityCollection col) {
        Jaxor target = col.resolveEntity(this._entity);
        return this.getMethodName(target.getEntity().getInterfaceName());
    }

    protected String getMethodName(String entityName) {
        if (this._alias == null) {
            return entityName;
        }
        return this._alias;
    }

    public String getResolverConstructor(String finder) {
        return "new ReferenceResolver(" + finder + ".class,this," + this.isUnique() + "," + this.getQueryAsArg() + "," + this.getFindAsArg() + ")";
    }

    public List getKeys() {
        return this._keys;
    }
}

