/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.provider.AbstractVfsComponent;
import org.apache.commons.vfs.provider.FileReplicator;
import org.apache.commons.vfs.provider.TemporaryFileStore;
import org.apache.commons.vfs.util.Messages;

public final class DefaultFileReplicator
extends AbstractVfsComponent
implements FileReplicator,
TemporaryFileStore {
    private static final Log log = LogFactory.getLog(class$org$apache$commons$vfs$impl$DefaultFileReplicator == null ? (class$org$apache$commons$vfs$impl$DefaultFileReplicator = DefaultFileReplicator.class$("org.apache.commons.vfs.impl.DefaultFileReplicator")) : class$org$apache$commons$vfs$impl$DefaultFileReplicator);
    private final ArrayList copies = new ArrayList();
    private File tempDir;
    private long filecount;
    static /* synthetic */ Class class$org$apache$commons$vfs$impl$DefaultFileReplicator;

    public DefaultFileReplicator(File tempDir) {
        this.tempDir = tempDir;
    }

    public DefaultFileReplicator() {
    }

    public void init() throws FileSystemException {
        if (this.tempDir == null) {
            this.tempDir = new File("vfs_cache").getAbsoluteFile();
        }
        this.filecount = new Random().nextInt() & 0xFFFF;
    }

    public void close() {
        while (this.copies.size() > 0) {
            File file = (File)this.copies.remove(0);
            try {
                FileObject fileObject = this.getContext().toFileObject(file);
                fileObject.delete(Selectors.SELECT_ALL);
            }
            catch (FileSystemException e) {
                String message = Messages.getString("vfs.impl/delete-temp.warn", file.getName());
                VfsLog.warn(this.getLogger(), log, message, e);
            }
        }
        if (this.tempDir != null && this.tempDir.exists() && this.tempDir.list().length == 0) {
            this.tempDir.delete();
            this.tempDir = null;
        }
    }

    public File allocateFile(String baseName) {
        String basename = this.createFilename(baseName);
        ++this.filecount;
        File file = this.createFile(this.tempDir, basename);
        this.copies.add(file);
        return file;
    }

    protected long getFilecount() {
        return this.filecount;
    }

    protected String createFilename(String baseName) {
        return "tmp_" + this.getFilecount() + "_" + baseName;
    }

    protected File createFile(File parent, String name) {
        return new File(parent, name);
    }

    public File replicateFile(FileObject srcFile, FileSelector selector) throws FileSystemException {
        String basename = srcFile.getName().getBaseName();
        File file = this.allocateFile(basename);
        FileObject destFile = this.getContext().toFileObject(file);
        destFile.copyFrom(srcFile, selector);
        return file;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

