/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.util.test;

import java.io.StringWriter;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.ws.commons.util.Base64;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Base64Test
extends TestCase {
    public void testBase64() throws Exception {
        for (int i = 0; i <= 256; ++i) {
            byte[] bytes = new byte[i];
            for (int j = 0; j < i; ++j) {
                bytes[j] = (byte)j;
            }
            String s = Base64.encode(bytes);
            byte[] result = Base64.decode(s);
            Base64Test.assertTrue(Arrays.equals(bytes, result));
        }
    }

    public void testSAXEncoder() throws Exception {
        for (int i = 0; i <= 256; ++i) {
            byte[] bytes = new byte[i];
            for (int j = 0; j < i; ++j) {
                bytes[j] = (byte)j;
            }
            final StringWriter sw = new StringWriter();
            DefaultHandler ch = new DefaultHandler(){

                public void characters(char[] pChars, int pOffset, int pLen) throws SAXException {
                    sw.write(pChars, pOffset, pLen);
                }
            };
            Base64.SAXEncoder encoder = new Base64.SAXEncoder(new char[4096], 0, null, ch);
            Base64.EncoderOutputStream eos = new Base64.EncoderOutputStream(encoder);
            eos.write(bytes);
            eos.close();
            String s = sw.toString();
            byte[] result = Base64.decode(s);
            Base64Test.assertTrue(Arrays.equals(bytes, result));
        }
    }
}

