/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcLocalClientConfig;
import org.apache.xmlrpc.client.XmlRpcStreamTransport;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.server.XmlRpcServer;
import org.apache.xmlrpc.server.XmlRpcStreamServer;

public class XmlRpcLocalStreamTransport
extends XmlRpcStreamTransport {
    private final XmlRpcStreamServer localServer = new LocalServer();

    public XmlRpcLocalStreamTransport(XmlRpcClient pClient) {
        super(pClient);
    }

    protected Object newConnection(XmlRpcStreamRequestConfig pConfig) throws XmlRpcClientException {
        return new LocalStreamConnection();
    }

    protected void closeConnection(Object pConnection) throws XmlRpcClientException {
        LocalStreamConnection lsc = (LocalStreamConnection)pConnection;
        if (lsc.ostream != null) {
            try {
                lsc.ostream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected OutputStream newOutputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection) throws XmlRpcClientException {
        LocalStreamConnection lsc = (LocalStreamConnection)pConnection;
        lsc.ostream = new ByteArrayOutputStream();
        return lsc.ostream;
    }

    protected InputStream newInputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection) throws XmlRpcException {
        LocalStreamConnection lsc = (LocalStreamConnection)pConnection;
        try {
            this.localServer.execute(pConfig, pConnection);
        }
        catch (IOException e) {
            throw new XmlRpcException(e.getMessage(), e);
        }
        return new ByteArrayInputStream(lsc.istream.toByteArray());
    }

    protected boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig pConfig, Object pConnection) {
        return pConfig.isGzipRequesting();
    }

    protected InputStream newInputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection, byte[] pContent) throws XmlRpcException {
        throw new IllegalStateException("Not implemented");
    }

    private class LocalServer
    extends XmlRpcStreamServer {
        private LocalServer() {
        }

        public Object execute(XmlRpcRequest pRequest) throws XmlRpcException {
            XmlRpcServer server = ((XmlRpcLocalClientConfig)pRequest.getConfig()).getXmlRpcServer();
            return server.execute(pRequest);
        }

        protected InputStream newInputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection) throws IOException {
            LocalStreamConnection lsc = (LocalStreamConnection)pConnection;
            return new ByteArrayInputStream(lsc.ostream.toByteArray());
        }

        protected OutputStream newOutputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection) throws IOException {
            LocalStreamConnection lsc = (LocalStreamConnection)pConnection;
            lsc.istream = new ByteArrayOutputStream();
            return lsc.istream;
        }

        protected void closeConnection(Object pConnection) throws IOException {
            LocalStreamConnection lsc = (LocalStreamConnection)pConnection;
            if (lsc.istream != null) {
                try {
                    lsc.istream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private class LocalStreamConnection {
        ByteArrayOutputStream ostream;
        ByteArrayOutputStream istream;

        private LocalStreamConnection() {
        }
    }
}

