/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.util.Iterator;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.XmlRpcRequestConfig;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcLocalClientConfig;
import org.apache.xmlrpc.client.XmlRpcTransportImpl;
import org.apache.xmlrpc.common.XmlRpcExtensionException;

public class XmlRpcLocalTransport
extends XmlRpcTransportImpl {
    public XmlRpcLocalTransport(XmlRpcClient pClient) {
        super(pClient);
    }

    private boolean isExtensionType(Object pObject) {
        if (pObject == null) {
            return true;
        }
        if (pObject instanceof Object[]) {
            Object[] objects = (Object[])pObject;
            for (int i = 0; i < objects.length; ++i) {
                if (!this.isExtensionType(objects[i])) continue;
                return true;
            }
            return false;
        }
        if (pObject instanceof Map) {
            Map map = (Map)pObject;
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!this.isExtensionType(entry.getKey()) && !this.isExtensionType(entry.getValue())) continue;
                return true;
            }
            return false;
        }
        return !(pObject instanceof Integer) && !(pObject instanceof String) && !(pObject instanceof byte[]) && !(pObject instanceof Double);
    }

    public Object sendRequest(XmlRpcRequest pRequest) throws XmlRpcException {
        Object result;
        XmlRpcRequestConfig config = pRequest.getConfig();
        if (!config.isEnabledForExtensions()) {
            for (int i = 0; i < pRequest.getParameterCount(); ++i) {
                if (!this.isExtensionType(pRequest.getParameter(i))) continue;
                throw new XmlRpcExtensionException("Parameter " + i + " has invalid type, if isEnabledForExtensions() == false");
            }
        }
        try {
            result = ((XmlRpcLocalClientConfig)config).getXmlRpcServer().execute(pRequest);
        }
        catch (Throwable t) {
            if (t instanceof XmlRpcClientException) {
                throw (XmlRpcClientException)t;
            }
            throw new XmlRpcClientException("Failed to invoke method " + pRequest.getMethodName() + ": " + t.getMessage(), t);
        }
        if (!config.isEnabledForExtensions() && this.isExtensionType(result)) {
            throw new XmlRpcExtensionException("Result has invalid type, if isEnabledForExtensions() == false");
        }
        return result;
    }
}

