/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Map;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.Field;
import org.postgresql.jdbc2.DatabaseMetaData;
import org.postgresql.jdbc2.PreparedStatement;
import org.postgresql.jdbc2.ResultSet;
import org.postgresql.jdbc2.Statement;
import org.postgresql.jdbc2.UpdateableResultSet;
import org.postgresql.util.PSQLException;

public class Connection
extends org.postgresql.Connection
implements java.sql.Connection {
    protected DatabaseMetaData metadata;
    protected Map typemap;
    protected int isolationLevel = 2;

    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
    }

    public void close() throws SQLException {
        if (this.pg_stream != null) {
            try {
                this.pg_stream.close();
            }
            catch (IOException iOException) {}
            this.pg_stream = null;
        }
    }

    public void commit() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        this.ExecSQL("commit");
        this.autoCommit = true;
        this.ExecSQL("begin");
        this.doIsolationLevel();
        this.autoCommit = false;
    }

    public java.sql.Statement createStatement() throws SQLException {
        return this.createStatement(1004, 1007);
    }

    public java.sql.Statement createStatement(int n, int n2) throws SQLException {
        Statement statement = new Statement(this);
        statement.setResultSetType(n);
        statement.setResultSetConcurrency(n2);
        return statement;
    }

    private void doIsolationLevel() throws SQLException {
        String string = "SET TRANSACTION ISOLATION LEVEL";
        switch (this.isolationLevel) {
            case 2: {
                this.ExecSQL(String.valueOf(string) + " READ COMMITTED");
                return;
            }
            case 8: {
                this.ExecSQL(String.valueOf(string) + " SERIALIZABLE");
                return;
            }
        }
        throw new PSQLException("postgresql.con.isolevel", new Integer(this.isolationLevel));
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        if (this.metadata == null) {
            this.metadata = new DatabaseMetaData(this);
        }
        return this.metadata;
    }

    public Object getObject(String string, String string2) throws SQLException {
        SQLData sQLData;
        if (this.typemap != null && (sQLData = (SQLData)this.typemap.get(string)) != null) {
            throw Driver.notImplemented();
        }
        return super.getObject(string, string2);
    }

    protected java.sql.ResultSet getResultSet(org.postgresql.Connection connection, java.sql.Statement statement, Field[] fieldArray, Vector vector, String string, int n, int n2) throws SQLException {
        if (statement != null && statement.getResultSetConcurrency() == 1008) {
            return new UpdateableResultSet((Connection)connection, fieldArray, vector, string, n, n2);
        }
        return new ResultSet((Connection)connection, fieldArray, vector, string, n, n2);
    }

    public int getTransactionIsolation() throws SQLException {
        this.clearWarnings();
        this.ExecSQL("show xactisolevel");
        SQLWarning sQLWarning = this.getWarnings();
        if (sQLWarning != null) {
            String string = sQLWarning.getMessage();
            this.clearWarnings();
            if (string.indexOf("READ COMMITTED") != -1) {
                return 2;
            }
            if (string.indexOf("READ UNCOMMITTED") != -1) {
                return 1;
            }
            if (string.indexOf("REPEATABLE READ") != -1) {
                return 4;
            }
            if (string.indexOf("SERIALIZABLE") != -1) {
                return 8;
            }
        }
        return 2;
    }

    public Map getTypeMap() throws SQLException {
        return this.typemap;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.firstWarning;
    }

    public boolean isClosed() throws SQLException {
        if (this.pg_stream == null) {
            return true;
        }
        try {
            java.sql.ResultSet resultSet = this.ExecSQL(" ");
            if (resultSet != null) {
                resultSet.close();
            }
            return false;
        }
        catch (SQLException sQLException) {
            return true;
        }
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1004, 1007);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw new PSQLException("postgresql.con.call");
    }

    public java.sql.PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1004, 1007);
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement = new PreparedStatement(this, string);
        preparedStatement.setResultSetType(n);
        preparedStatement.setResultSetConcurrency(n2);
        return preparedStatement;
    }

    public void rollback() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        this.ExecSQL("rollback");
        this.autoCommit = true;
        this.ExecSQL("begin");
        this.doIsolationLevel();
        this.autoCommit = false;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.autoCommit == bl) {
            return;
        }
        if (bl) {
            this.ExecSQL("end");
        } else {
            this.ExecSQL("begin");
            this.doIsolationLevel();
        }
        this.autoCommit = bl;
    }

    public void setCatalog(String string) throws SQLException {
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.readOnly = bl;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.isolationLevel = n;
        this.doIsolationLevel();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.typemap = map;
    }
}

