/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcHttpClientConfig;
import org.apache.xmlrpc.client.XmlRpcStreamTransport;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.util.HttpUtil;

public abstract class XmlRpcHttpTransport
extends XmlRpcStreamTransport {
    public static final String USER_AGENT = "Apache XML RPC 3.0";

    protected XmlRpcHttpTransport(XmlRpcClient pClient) {
        super(pClient);
    }

    protected abstract void setRequestHeader(Object var1, String var2, String var3);

    protected void setCredentials(XmlRpcHttpClientConfig pConfig, Object pConnection) throws XmlRpcClientException {
        String auth;
        try {
            auth = HttpUtil.encodeBasicAuthentication(pConfig.getBasicUserName(), pConfig.getBasicPassword(), pConfig.getBasicEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new XmlRpcClientException("Unsupported encoding: " + pConfig.getBasicEncoding(), e);
        }
        if (auth != null) {
            this.setRequestHeader(pConnection, "Authorization", "Basic " + auth);
        }
    }

    protected void setContentLength(Object pConnection, int pLength) {
        this.setRequestHeader(pConnection, "Content-Length", Integer.toString(pLength));
    }

    protected InputStream getInputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection, byte[] pContent) throws XmlRpcException {
        if (pContent != null) {
            this.setContentLength(pConnection, pContent.length);
        }
        return super.getInputStream(pConfig, pConnection, pContent);
    }

    protected void setCompressionHeaders(XmlRpcHttpClientConfig pConfig, Object pConnection) {
        if (pConfig.isGzipCompressing()) {
            this.setRequestHeader(pConnection, "Content-Encoding", "gzip");
        }
        if (pConfig.isGzipRequesting()) {
            this.setRequestHeader(pConnection, "Accept-Encoding", "gzip");
        }
    }

    protected String getUserAgent() {
        return USER_AGENT;
    }

    protected void initConnection(XmlRpcStreamRequestConfig pConfig, Object pConnection) throws XmlRpcClientException {
        super.initConnection(pConfig, pConnection);
        XmlRpcHttpClientConfig config = (XmlRpcHttpClientConfig)pConfig;
        this.setRequestHeader(pConnection, "Content-Type", "text/xml");
        this.setRequestHeader(pConnection, "User-Agent", this.getUserAgent());
        this.setCredentials(config, pConnection);
        this.setCompressionHeaders(config, pConnection);
    }

    protected abstract boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig var1, Object var2);

    protected boolean isUsingByteArrayOutput(XmlRpcStreamRequestConfig pConfig) {
        return !pConfig.isEnabledForExtensions() || !((XmlRpcHttpClientConfig)pConfig).isContentLengthOptional();
    }
}

