/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.webserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.server.XmlRpcStreamServer;
import org.apache.xmlrpc.util.ThreadPool;
import org.apache.xmlrpc.webserver.Connection;
import org.apache.xmlrpc.webserver.ConnectionServer;

public class WebServer
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xmlrpc$webserver$WebServer == null ? (class$org$apache$xmlrpc$webserver$WebServer = WebServer.class$("org.apache.xmlrpc.webserver.WebServer")) : class$org$apache$xmlrpc$webserver$WebServer));
    protected ServerSocket serverSocket;
    private Thread listener;
    private ThreadPool pool;
    protected final List accept = new ArrayList();
    protected final List deny = new ArrayList();
    protected final XmlRpcStreamServer server = this.newXmlRpcStreamServer();
    private InetAddress address;
    private int port;
    private boolean paranoid;
    static final String HTTP_11 = "HTTP/1.1";
    static /* synthetic */ Class class$org$apache$xmlrpc$webserver$WebServer;

    protected XmlRpcStreamServer newXmlRpcStreamServer() {
        return new ConnectionServer();
    }

    public WebServer(int pPort) {
        this(pPort, null);
    }

    public WebServer(int pPort, InetAddress pAddr) {
        this.address = pAddr;
        this.port = pPort;
    }

    protected ServerSocket createServerSocket(int pPort, int backlog, InetAddress addr) throws IOException {
        return new ServerSocket(pPort, backlog, addr);
    }

    private synchronized void setupServerSocket(int backlog) throws IOException {
        int i = 1;
        try {
            this.serverSocket = this.createServerSocket(this.port, backlog, this.address);
            if (this.serverSocket.getSoTimeout() <= 0) {
                this.serverSocket.setSoTimeout(4096);
            }
            return;
        }
        catch (BindException e) {
            if (i == 10) {
                throw e;
            }
            long waitUntil = System.currentTimeMillis();
            while (true) {
                long l;
                if ((l = waitUntil - System.currentTimeMillis()) <= 0L) {
                    continue;
                }
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException ex) {
                }
            }
        }
    }

    public void start() throws IOException {
        this.setupServerSocket(50);
        if (this.listener == null) {
            this.listener = new Thread((Runnable)this, "XML-RPC Weblistener");
            this.listener.start();
        }
    }

    public void setParanoid(boolean pParanoid) {
        this.paranoid = pParanoid;
    }

    public void acceptClient(String pAddress) {
        this.accept.add(new AddressMatcher(pAddress));
    }

    public void denyClient(String pAddress) {
        this.deny.add(new AddressMatcher(pAddress));
    }

    protected boolean allowConnection(Socket s) {
        AddressMatcher match;
        int i;
        if (!this.paranoid) {
            return true;
        }
        int l = this.deny.size();
        byte[] addr = s.getInetAddress().getAddress();
        for (i = 0; i < l; ++i) {
            match = (AddressMatcher)this.deny.get(i);
            if (!match.matches(addr)) continue;
            return false;
        }
        l = this.accept.size();
        for (i = 0; i < l; ++i) {
            match = (AddressMatcher)this.accept.get(i);
            if (!match.matches(addr)) continue;
            return true;
        }
        return false;
    }

    protected ThreadPool.Task newTask(WebServer pServer, XmlRpcStreamServer pXmlRpcServer, Socket pSocket) throws IOException {
        return new Connection(pServer, pXmlRpcServer, pSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block20: {
            this.pool = new ThreadPool(this.server.getMaxThreads(), "XML-RPC");
            try {
                while (this.listener != null) {
                    try {
                        socket = this.serverSocket.accept();
                        try {
                            socket.setTcpNoDelay(true);
                        }
                        catch (SocketException socketOptEx) {
                            this.log(socketOptEx);
                        }
                        try {
                            if (this.allowConnection(socket)) {
                                task = this.newTask(this, this.server, socket);
                                if (this.pool.startTask(task)) {
                                    socket = null;
                                } else {
                                    this.log("Maximum load of " + this.pool.getMaxThreads() + " exceeded, rejecting client");
                                }
                            }
                            var4_6 = null;
                            if (socket == null) continue;
                        }
                        catch (Throwable var3_8) {
                            var4_6 = null;
                            if (socket == null) throw var3_8;
                            try {
                                socket.close();
                                throw var3_8;
                            }
                            catch (Throwable ignore) {
                                // empty catch block
                            }
                            throw var3_8;
                        }
                        try {}
                        catch (Throwable ignore) {
                        }
                        socket.close();
                    }
                    catch (InterruptedIOException checkState) {
                    }
                    catch (Throwable t) {
                        this.log(t);
                    }
                }
                var7_9 = null;
                if (this.serverSocket == null) break block20;
            }
            catch (Throwable var6_13) {
                var7_10 = null;
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException e) {
                        this.log(e);
                    }
                }
                this.pool.shutdown();
                throw var6_13;
            }
            ** try [egrp 5[TRYBLOCK] [8 : 186->196)] { 
lbl58:
            // 1 sources

            this.serverSocket.close();
            break block20;
lbl60:
            // 1 sources

            catch (IOException e) {
                this.log(e);
            }
        }
        this.pool.shutdown();
    }

    public synchronized void shutdown() {
        if (this.listener != null) {
            Thread l = this.listener;
            this.listener = null;
            l.interrupt();
            this.pool.shutdown();
        }
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public void log(Throwable pError) {
        log.error((Object)pError.getMessage(), pError);
    }

    public synchronized void log(String pMessage) {
        log.error((Object)pMessage);
    }

    public XmlRpcStreamServer getXmlRpcServer() {
        return this.server;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AddressMatcher {
        private final int[] pattern;

        AddressMatcher(String address) {
            try {
                this.pattern = new int[4];
                StringTokenizer st = new StringTokenizer(address, ".");
                if (st.countTokens() != 4) {
                    throw new IllegalArgumentException();
                }
                for (int i = 0; i < 4; ++i) {
                    String next = st.nextToken();
                    this.pattern[i] = "*".equals(next) ? 256 : Integer.parseInt(next);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\"" + address + "\" does not represent a valid IP address");
            }
        }

        boolean matches(byte[] pAddress) {
            for (int i = 0; i < 4; ++i) {
                if (this.pattern[i] > 255 || this.pattern[i] == pAddress[i]) continue;
                return false;
            }
            return true;
        }
    }
}

