/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.webserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.common.XmlRpcHttpRequestConfigImpl;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.server.XmlRpcHttpServerConfig;
import org.apache.xmlrpc.server.XmlRpcStreamServer;
import org.apache.xmlrpc.util.HttpUtil;

public class XmlRpcServletServer
extends XmlRpcStreamServer {
    protected RequestData newConfig(HttpServletRequest pRequest) {
        return new RequestData(pRequest);
    }

    protected RequestData getConfig(HttpServletRequest pRequest) {
        RequestData result = this.newConfig(pRequest);
        XmlRpcHttpServerConfig serverConfig = (XmlRpcHttpServerConfig)this.getConfig();
        result.setBasicEncoding(serverConfig.getBasicEncoding());
        result.setContentLengthOptional(serverConfig.isContentLengthOptional());
        result.setEnabledForExtensions(serverConfig.isEnabledForExtensions());
        result.setGzipCompressing(HttpUtil.isUsingGzipEncoding(pRequest.getHeader("Content-Encoding")));
        result.setGzipRequesting(HttpUtil.isUsingGzipEncoding(pRequest.getHeaders("Accept-Encoding")));
        result.setEncoding(pRequest.getCharacterEncoding());
        HttpUtil.parseAuthorization(result, pRequest.getHeader("Authorization"));
        return result;
    }

    protected RequestData newRequestData(HttpServletRequest pRequest) {
        return new RequestData(pRequest);
    }

    public void execute(HttpServletRequest pRequest, HttpServletResponse pResponse) throws ServletException, IOException {
        RequestData config = this.getConfig(pRequest);
        try {
            super.execute(config, pResponse);
        }
        catch (XmlRpcException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected boolean isContentLengthRequired(XmlRpcStreamRequestConfig pConfig) {
        RequestData data = (RequestData)pConfig;
        if (data.isEnabledForExtensions()) {
            return true;
        }
        return !((XmlRpcHttpServerConfig)this.getConfig()).isContentLengthOptional();
    }

    protected InputStream newInputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection) throws IOException {
        return ((RequestData)pConfig).request.getInputStream();
    }

    protected OutputStream newOutputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection) throws IOException {
        HttpServletResponse response = (HttpServletResponse)pConnection;
        response.setContentType("text/xml");
        return response.getOutputStream();
    }

    protected OutputStream getOutputStream(XmlRpcStreamRequestConfig pConfig, Object pConnection, int pSize) throws IOException {
        if (pSize != -1) {
            ((HttpServletResponse)pConnection).setContentLength(pSize);
        }
        return super.getOutputStream(pConfig, pConnection, pSize);
    }

    protected void closeConnection(Object pConnection) throws IOException {
        ((HttpServletResponse)pConnection).getOutputStream().close();
    }

    protected static class RequestData
    extends XmlRpcHttpRequestConfigImpl {
        private final HttpServletRequest request;

        public RequestData(HttpServletRequest pRequest) {
            this.request = pRequest;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }
    }
}

