#!/bin/sh
# the next line restarts using tclsh \
    exec tclsh "$0" "$@"


#----------------------------------------------------------------------------------------
# Local and Remote data organization notes
#----------------------------------------------------------------------------------------
# Batch upload of retrospective study maps local data organization
# to XNAT data model in the following way:
# xnat Project = PienaarGrant
# xnat Project contains list of unique xnat SubjectIDs (= local MRIDs)
# Each xnat SubjectID contains a list of xnat "Experiments"
# Each xnat Experiment is an "MRSession" with unique ID (and label = local dirname from dcm_mrid.txt)
# Each xnat MRSession labeled with local dirname contains set of xnat "Scans" (listed in local toc.txt)
# Each xnat Scan contains the image data.
# Project, Subjects, Experiments, and Scans can all have searchable metadata
# Projects, Experiments can have associated files (dcm_mrid.txt, toc.txt, error logs, etc.)


#----------------------------------------------------------------------------------------
# A schematic of the local organization looks like this:
#----------------------------------------------------------------------------------------
#
# Project root dir
#            |...
# { MRSession1,  MRSession2, ..., MRSessionN} + {projectfiles = dcm_MRID.log, dcm_MRID_age.log, dcm_MRID_ageDays.log, error.log}
#                                                    ...|
#                 { s1.dcm, s2.dcm,...,sm.dcm } + {sessionfiles = toc.txt, toc.err, log/*, log_V/*}
#


#----------------------------------------------------------------------------------------
# A schematic of the xnat organization looks like this:
#----------------------------------------------------------------------------------------
#
# Project + {projectfiles.zip}
#     |...
# { SubjectID1, SubjectID2, ... SubjectIDN }
#                                                  ...|
# List of "Experiments" { MRSession, MRSession, ..., MRSession}
#                                               |...               
#                                    {scan1...scanN} + {sessionfiles.zip}    
#
# An XNAT "Experiment" is an XNAT "imagingSession"
# An ImagingSession may be a MRSession, PETSession or CTSession (on central.xnat.org)
# -we are calling each local directory for a given MRID a new XNAT Experiment (MRSession).
# Each XNAT "imagingSession" contains a collection of XNAT "scans".
# we are calling each scan in a given local directory an XNAT "scan" in the MRSession.




###########################################
# globals: Edit the file XNATglobals to customize.
source XNATglobals.tcl
###########################################
# create an XNAT remote session; avoids authentication at each transaction
source XNATsession.tcl
# misc procs for error checking and logging
source XNATutilities.tcl
###########################################
# query and parsing procs
source XNATquery.tcl
###########################################
# representation in local project
source XNATdatamodel.tcl
###########################################
# methods that add data and metadata
source XNATupload.tcl
###########################################
# methods that download data
source XNATdownload.tcl



###########################################
# simple command line argument parsing
proc Usage { {msg ""} } {

    set msg "$msg\nusage: PienaarGrant -d localDataDirectory\n"
    puts stderr $msg
    
}


###########################################
# main
##
## Some simple argument parsing
##
set strippedargs ""
set argc [llength $argv]
for {set i 0} {$i < $argc} {incr i} {
    set a [lindex $argv $i]
    switch -glob -- $a {
        "-d" {
            incr i
            if { $i == $argc } {
                Usage "Missing localDataDirectory argument"
            } else {
                puts "[lindex $argv $i]"
                set ::XNAT(localDataDirectory) [lindex $argv $i]
            }
        }
        default {
            lappend strippedargs $a
        }
    }
}

if { $argc != 2 } {
    Usage ""
    exit 1
}



##
## directory test
##
if { ![ file exists $::XNAT(localDataDirectory)] } {
    puts "...>>>>>>ERROR: Can not find $::XNAT(localDataDirectory)"
    exit 1
}
if { ![ file isdirectory $::XNAT(localDataDirectory)] } {
    puts "...>>>>>>ERROR: $::XNAT(localDataDirectory) appears not to be a directory."
    exit 1
}

puts "\n"
puts "*******************************************************************"
puts "* This script does *NOT* de-identify or anonymize data before upload:"
puts "* Files being uploaded may contain protected medical information."
puts "* Please manage the access settubgs on the xnat project appropriately."
puts "* ---------------------------------------------------------------------------"
puts "* This script does *NOT* perform any Q/A using file header information."
puts "*******************************************************************"

##
## Enter directory and process files of interest
##
puts "\n"
puts "---------------------------------------------------------------------------"
puts "Starting script:"
puts "---------------------------------------------------------------------------"
set cwd [pwd]
cd $::XNAT(localDataDirectory) 
set o [pwd]
puts "...changing directory to: $o"


##
## Add all (or new) project data 
##
BulkUpload













     