

###########################################
# create a list of unique mrids (from file dcm_MRID.log)
proc AddToUniqueMRIDList {sessionName MRID} {
    
    # test to see if MRID is already here.
    set newid 1
    if { [info exists ::XNAT(MRIDs) ] } {
        set len [llength $::XNAT(MRIDs) ]
        for { set i 0 } {$i < $len} {incr i} {
            set id [ lindex $::XNAT(MRIDs) $i ]
            if { $id == $MRID } {
                set newid 0
                break
            }
        }
    } 
    
    if { $newid } {
        lappend ::XNAT(MRIDs) $MRID 
    }
}




###########################################
# create internal map of directories containing scan data to mrids
# Assuming mrids are unique, each mrid will get a list of dir names
proc CreateMapFromMRIDToMRSession {sessionName MRID} {

    # test to see if MRID is already here;
    # in the end should have same number of maps as unique MRIDs
    if { ![info exists ::XNATupload($MRID,MRSessionDirnameList) ] } {
        incr ::XNATupload(numberOfSubjectSessionMaps)
    }
    # create a list of directoryNames for each MRID
    lappend ::XNATupload($MRID,MRSessionDirnameList) $sessionName

}





###########################################
# grab all subject and experiment data in toc.txt
# return 1 for success, 0 for failure
proc ParseTOC { dir } {

    set cwd [ pwd ]
    cd $dir

    # check for file
    if { ![ file exists "toc.txt"] || [file isdirectory "toc.txt"] } {
        puts "...>>>>>>WARNING: can not find file $dir/$toc.txt in -- not extracting demographics."
        set ::XNATupload(dob) ""
        set ::XNATupload(yob) ""
        set ::XNATupload(scannermfg) "unspecified"
        set ::XNATupload(scannermod) ""
        set ::XNATupload(studydate) ""
        set ::XNATupload(gender) ""
        return 0
    }

    # read 
    set fp [ open "toc.txt" "r"]
    set data [ read $fp ]
    close $fp
    set data [ split $data "\n"]

    # try to parse all subject and experiment data we can use on XNAT
    foreach line $data {
        if { [llength $line] > 1 } {

            #date of birth?
            set ::XNATupload(dob) ""
            set probe [ lsearch $line "Birthday"]
            if { $probe >= 0 } {
                set len [ llength $line ]
                #YYYYMMDD 
                set ::XNATupload(dob) [ lindex $line [expr $len-1]]
                set yy [string range $::XNATupload(dob) 0 3 ]
                set mm [ string range $::XNATupload(dob) 4 5 ]
                set dd [ string range $::XNATupload(dob) 6 7 ]
                #YYYY-MM-DD                 
                set ::XNATupload(dob) $yy-$mm-$dd
                set ::XNATupload(yob) [ string range $::XNATupload(dob) 0 3 ]
                if { $::XNAT(verbose) } {
                    puts ".........experiment ($dir) subject dateofbirth: $::XNATupload(dob)"
                    puts ".........experiment ($dir) subject yearofbirth: $::XNATupload(yob)"
                }
            }

            # age?
            set age ""
            set agedays 0
            set probe [ lsearch $line "Age"]
            if { $probe >= 0 } {
                set len [ llength $line ]
                set age [ lindex $line [expr $len-1]]
                if { [string first "Y" $age ] >= 0 } {
                    set years [ string trim $age "Y"]
                    set years [ string trimleft $years "0"]
                    set ::XNATupload(age) $years
                } 
                if { [string first "M" $age ] >= 0 } {
                    set months [ string trim $age "M"]
                    set months [ string trimleft $months "0"]
                    # convert to years for XNAT!
                    set ::XNATupload(age) [ expr $months / 12.0 ]
                } 
                if { [string first "W" $age ] >= 0 } {
                    set weeks [ string trim $age "W"]
                    set weeks [ string trimleft $weeks "0"]
                    # convert to years for XNAT!
                    set ::XNATupload(age) [ expr $weeks / 52.0 ]
                } 
                if { [string first "D" $age ] >= 0 } {
                    set days [ string trim $age "D"]
                    set days [ string trimleft $days "0"]
                    # convert to years for XNAT!
                    set ::XNATupload(age) [ expr $days / 365.0 ]
                } 
                if { $::XNAT(verbose) } {
                    puts ".........experiment ($dir) subject age: $age"
                }
            }

            #scanner manufacturer?
            set probe [ lsearch $line "Manufacturer"]
            if { $probe >= 0 } {
                set len [ llength $line ]
                set ::XNATupload(scannermfg) [ lrange $line 2 end]
                if { $::XNAT(verbose) } {
                    puts ".........experiment ($dir) scanner: $::XNATupload(scannermfg)"
                }
            }

            #scanner model?
            set probe [ lsearch $line "Model"]
            if { $probe >= 0 } {
                set len [ llength $line ]
                set ::XNATupload(scannermod) [ lrange $line 2 end]
                if { $::XNAT(verbose) } {
                    puts ".........experiment ($dir) scanner model: $::XNATupload(scannermod)"
                }
            }

            # date
            set ::XNATupload(studydate) ""
            set probe [ lsearch $line "Date"]
            if { $probe >= 0 } {
                set len [ llength $line ]
                #YYYYMMDD 
                set ::XNATupload(studydate) [ lindex $line [expr $len-1]]
                set ::XNATupload(studydate) [ lindex $line [expr $len-1]]
                set yy [string range $::XNATupload(studydate) 0 3 ]
                set mm [ string range $::XNATupload(studydate) 4 5 ]
                set dd [ string range $::XNATupload(studydate) 6 7 ]
                #YYYY-MM-DD                 
                set ::XNATupload(studydate) $yy-$mm-$dd

                if { $::XNAT(verbose) } {
                    puts ".........experiment ($dir) subject studydate: $::XNATupload(studydate)"
                }
            }
            # scan date?
            set probe [ lsearch $line "ScanDate"]
            if { $probe >= 0 } {
                set len [ llength $line ]
                #YYYYMMDD 
                set ::XNATupload(studydate) [ lindex $line [expr $len-1]]
                set yy [string range $::XNATupload(studydate) 0 3 ]
                set mm [ string range $::XNATupload(studydate) 4 5 ]
                set dd [ string range $::XNATupload(studydate) 6 7 ]
                #YYYY-MM-DD                 
                set ::XNATupload(studydate) $yy-$mm-$dd

                if { $::XNAT(verbose) } {
                    puts ".........experiment ($dir) subject studydate: $::XNATupload(studydate)"
                }
            }
            set probe [ lsearch $line "Scan-Date"]
            if { $probe >=0 } {
                set len [ llength $line ]
                #YYYYMMDD 
                set ::XNATupload(studydate) [ lindex $line [expr $len-1]]
                set yy [string range $::XNATupload(studydate) 0 3 ]
                set mm [ string range $::XNATupload(studydate) 4 5 ]
                set dd [ string range $::XNATupload(studydate) 6 7 ]
                #YYYY-MM-DD                 
                set ::XNATupload(studydate) $yy-$mm-$dd

                if { $::XNAT(verbose) } {
                    puts ".........experiment ($dir) subject studydate: $::XNATupload(studydate)"
                }
            }

            #gender?
            set probe [ lsearch $line "Sex"]
            set probe2 [ lsearch $line "Gender"]
            if { $probe >= 0 || $probe2 >= 0} {
                set len [ llength $line ]
                set ::XNATupload(gender) [ lindex $line [expr $len-1]]
                if { $::XNATupload(gender) == "M" || $::XNATupload(gender) == "m" || $::XNATupload(gender) == "MALE" || $::XNATupload(gender) == "male" } {
                    set ::XNATupload(gender) male
                } elseif { $::XNATupload(gender) == "F" || $::XNATupload(gender) == "f" || $::XNATupload(gender) == "FEMALE" || $::XNATupload(gender) == "female" } {
                    set ::XNATupload(gender) female
                }
                if { $::XNAT(verbose) } {
                    puts ".........experiment ($dir) subject gender: $::XNATupload(gender)"
                }
            }
        }
    }
    # come back to top level directory
    cd $cwd
    return 1
}




###########################################
# grab all scanss for subject from file toc.txt
# fill global list ::XNATupload(scanNames) with list of names and
# fill global list ::XNATupload(scanTypes) with list of scanType
# return 1 if success, 0 if fail.
proc GetScanList {  } {

    # check for file
    set ::XNATupload(scanNames) ""
    set ::XNATupload(scanTypes) ""
    if { ![ file exists "toc.txt"] || [file isdirectory "toc.txt"] } {
        puts "...>>>>>>WARNING: can not find file $dir/$toc.txt in -- not extracting list of scans."
        return 0
    }

    # read 
    set fp [ open "toc.txt" "r"]
    set data [ read $fp ]
    close $fp
    set data [ split $data "\n"]

    # parse out scans
    foreach line $data {
        # line should look like: "Scan scanname.dcm type"
        set len [ llength $line]
        if { $len >=3 } {
            set probe [ lindex $line 0]
            if { $probe == "Scan" || $probe == "scan" } {
                set scanName [ lindex $line 1 ]
                #grab the rest of the line as the type.
                set scanType [lindex $line 2 ]
                for { set j 3 } { $j < [expr $len] } { incr j } {
                    set s [lindex $line $j ]
                    set scanType "$scanType $s"
                }
                if { $scanName != "" } {
                    lappend ::XNATupload(scanNames) $scanName
                    if { $scanType != "" } {
                        lappend ::XNATupload(scanTypes) $scanType
                    } else {
                        lappend ::XNATupload(scanTypes) "unknown"
                    }
                }
            }
        }
    }

    if {$::XNAT(verbose) } {
        puts "...Found the following scans:"
        puts "......$::XNATupload(scanNames)"
        puts "......$::XNATupload(scanTypes)"
    }

    return 1
}





###########################################
# uploads entire local retrospective data
proc CreateProjectToDataModelMapping { } {

    if { ![ file exists "dcm_MRID.log"] } {
        puts "...>>>>>>ERROR: Cannot find file dcm_MRID.log."
        exit 1
    }
    if { ![ file exists "dcm_MRID_age.log"] } {
        puts "...>>>>>>ERROR: Cannot find file dcm_MRID_age.log."
        exit 1
    }
    if { ![ file exists "dcm_MRID_ageDays.log"] } {
        puts "...>>>>>>ERROR: Cannot find file dcm_MRID_ageDays.log."
        exit 1
    }


    ##
    ## get unique(?) list of MRIDs
    ##
    puts "...reading dcm_MRID.log"
    set fname "dcm_MRID.log"
    set fp [ open $fname "r" ]
    set data [ read $fp ]
    close $fp
    set data [ split $data "\n"]

    foreach line $data {
        if { [llength $line] > 1 } {
            set sessionName [lindex $line 0]
            set mrid [lindex $line 1]
            if { $mrid != "" } {
                AddToUniqueMRIDList $sessionName $mrid
                CreateMapFromMRIDToMRSession $sessionName $mrid
            }
        }
    }


    ##
    ## Error checking
    ##
    set num [llength $::XNAT(MRIDs)]
    puts "...got $num unique MRIDs"
    puts "...created $::XNATupload(numberOfSubjectSessionMaps) MRID-to-MRSession maps"           
    if { $::XNATupload(numberOfSubjectSessionMaps) != $num } {
        #puts "...>>>>>>WARNING: should have an MRID-to-MRSession map for each unique MRID... \n(Check file dcm_MRID.log  for multiple subjects with MRID=0 (or 00, 000, etc.)\n These are not being counted as unique.\n Only first will be created.)"
    }

}


