###########################################
# globals

# local data organization to XNATproject mapping & sessionID
unset -nocomplain ::XNAT(localDataDirectory)
unset -nocomplain ::XNAT(MRIDs)
unset -nocomplain ::XNAT(sessionID)
    
# XNAT settings: edit these as appropriate
set ::XNAT(client) "C:/cygwin/home/wjp/xnat_tools/XNATRestClient"
set ::XNAT(host) "http://central.xnat.org"
set ::XNAT(project) "PGRetro_Test"
set ::XNAT(username) "wjp"
set ::XNAT(password) "scubdub2"
set ::XNAT(verbose) 1
set ::XNAT(errorLogFile) "./XNATerrors.log"
set ::XNAT(projectFileNames) [list "dcm_MRID.log" \
                                  "dcm_MRID_age.log" \
                                  "dcm_MRID_ageDays.log" \
                                  "error.log" ]
set ::XNAT(sessionFileNames) [list "toc.err" \
                                  "toc.txt" \
                                  "log/dcm2trk.bash.err" \
                                  "log/dcm2trk.bash.std" \
                                  "log/dicom_seriesCollect.bash.err" \
                                  "log/dicom_seriesCollect.bash.log" \
                                  "log/dicom_seriesCollect.bash.opt" \
                                  "log/dicom_seriesCollect.bash.std" \
                                  "log/tract_meta.bash.log" \
                                  "log/toc.err" \
                                  "log/toc.txt" \
                                  "log_V/dcm2trk.bash.err" \
                                  "log_V/dcm2trk.bash.std" \
                                  "log_V/dicom_seriesCollect.bash.err" \
                                  "log_V/dicom_seriesCollect.bash.log" \
                                  "log_V/dicom_seriesCollect.bash.std" \
                                  "log_V/dicom_seriesCollect.bash.opt" \
                                  "log_V/tract_meta.bash.log"]


 # prefix to XNAT metadata specifications. edit these if API changes
set ::XNATupload(genderPrefix) "?xnat:subjectData/demographics\[@xsi:type=xnat:demographicData\]/gender="
set ::XNATupload(dobPrefix) "?xnat:subjectData/demographics\[@xsi:type=xnat:demographicData\]/dob="
set ::XNATupload(yobPrefix) "?xnat:subjectData/demographics\[@xsi:type=xnat:demographicData\]/yob="
set ::XNATupload(agePrefix) "?xnat:experimentData/age="
set ::XNATupload(studydatePrefix) "?xnat:experimentData/date="
set ::XNATupload(modalityPrefix) "?xnat:imageSessionData/modality=MR"
set ::XNATupload(scannerPrefix) "?xnat:imageSessionData/scanner="
set ::XNATupload(scanNames) ""
set ::XNATupload(scanTypes) ""
                 
# use these two for performing incremental uploads
# specify a list of MRIDs and a corresponding list of
# session directory names.
set ::XNATincrementalUpload(MRIDs) ""
set ::XNATincrementalUpload(directoryNames) ""

# testing guys
set ::XNATquery(ageMinInYears) 0.5
set ::XNATquery(ageMaxInYears) 2.0
set ::XNATupload(AddProjectFiles) 1
set ::XNATupload(CreateAllSubjects) 1
set ::XNATupload(CreateAllMRSessions) 1
set ::XNATupload(AddAllScanData) 1
set ::XNATupload(AddSessionFiles) 1
set ::XNATupload(numberOfSubjectSessionMaps) 0

# controls and globals for download
set ::XNATdownload(rootDirectory) "./DLTest"

