###########################################
# return 1 if found, 0 if not found, -1 if error
proc QueryForProject { projectID } {

    if { $::XNAT(verbose) } {
        puts "...Checking for project=$projectID"
    }

    # see if project exists & do error checking on response.
    set xml [ exec $::XNAT(client) -host $::XNAT(host) -user_session $::XNAT(sessionID) -m GET -remote /REST/projects/$projectID?format=xml]
    if { [ErrorCheckOnResponse $xml] > 0 } {
        puts "...>>>>>>ERROR: Query for project returned error."
        return -1
    }

    #
    # NOTE: if response template changes, must update this specific search.
    # simple parsing:
    set ::XNATquery(projectParseString) "Project\ ID=\"$projectID\"\ "
    if { [ string first $::XNATquery(projectParseString) $xml ] < 0  } {
        puts "...>>>>>>ERROR: Project $projectID does not exist. Create this project on $::XNAT(host) using the web interface."
        return 0
    }

    return 1

}


###########################################
# return 1 if found, 0 if not found, -1 if error
proc QueryForSubject { subjectID } {


    # see if subject already exists & do error checking on response.
    set xml [exec $::XNAT(client) -host $::XNAT(host) -user_session $::XNAT(sessionID) -m GET -remote /REST/projects/$::XNAT(project)/subjects/$subjectID?format=xml]
    if { [ErrorCheckOnResponse $xml] > 0 } {
        puts "...>>>>>>ERROR: Query for subject returned error."
        return -1
    }

    set ::XNATquery(subjectParseString1) "Subject\ ID=\"$subjectID\"\ "
    set ::XNATquery(subjectParseString2) "project=\"$::XNAT(project)\"\ label=\"$subjectID\""
    #
    # NOTE: if response template changes, must update this specific search.
    # simple parsing:
    if { [ string first $::XNATquery(subjectParseString1) $xml ] >= 0  || \
             [ string first $::XNATquery(subjectParseString2) $xml ] >= 0} {
        return 1
    }

    return 0

}




###########################################
# return 1 if found, 0 if not found -1 if error
proc QueryForExperiment { subjectID expLabel} {


    if { [QueryForSubject $subjectID] != 1 } {
        puts "...>>>>>>ERROR: Can't find subject $subjectID for experiment."
        return -1
    }

    # see if experiment already exists & do error checking on response.
    set xml [exec $::XNAT(client) -host $::XNAT(host) -user_session $::XNAT(sessionID) -m GET -remote /REST/projects/$::XNAT(project)/subjects/$subjectID/experiments/$expLabel?format=xml]
    if { [ErrorCheckOnResponse $xml] > 0 } {
        puts "...>>>>>>ERROR: Query for experiment returned error."
        return -1
    }

    # 
    # NOTE: if response template changes, must update this specific search.
    # simple parsing:
    set ::XNATquery(experimentParseString1) "Session\ ID=\"$expLabel\"\ "
    set ::XNATquery(experimentParseString2) "project=\"$::XNAT(project)\"\ label=\"$expLabel\""
    if { [ string first $::XNATquery(experimentParseString1) $xml ] >= 0  || \
             [ string first $::XNATquery(experimentParseString2) $xml ] >= 0} {
        return 1
    }

    return 0
}



###########################################
# return experimentID  if found, 0 if not found -1 if error
proc QueryForExperimentID { subjectID expLabel } {

    if { $::XNAT(verbose) } {
        puts "...Finding ID for experimentLabel=$expLabel for subject=$subjectID in project=$::XNAT(project)"
    }

    if { [QueryForSubject $subjectID] != 1 } {
        puts "...>>>>>>ERROR: Can't find subject $subjectID for experiment."
        return -1
    }

    # see if experiment already exists & do error checking on response.
    # NOTE: if explabels are not unique, then this will return MULTIPLE ids
    # in this project's approach, these should always be unique (can't have two local dirs with same name...)
    set xml [exec $::XNAT(client) -host $::XNAT(host) -user_session $::XNAT(sessionID) -m GET -remote /REST/projects/$::XNAT(project)/subjects/$subjectID/experiments/$expLabel?format=xml]
    if { [ErrorCheckOnResponse $xml] > 0 } {
        puts "...>>>>>>ERROR: Query for experiment returned error."
        return -1
    }

    # 
    # NOTE: if response template changes, must update this specific search.
    # simple parsing:
    set expID 0
    set ::XNATquery(experimentParseString) "project=\"$::XNAT(project)\"\ label=\"$expLabel\""
    set index [ string first $::XNATquery(experimentParseString) $xml ]

    if {$index  >= 0 } {
        set index1 [ string first "Session\ ID=" $xml ]
        set index2 [ string first "project=" $xml ]
        if { $index1 >= 0 && $index2 >= 0 } {
            set snip [ string range $xml $index1 $index2 ]
            set index1 [ string first "\"" $snip ]
            set index2 [ string last "\"" $snip ]
            set expID [ string range $snip [expr $index1+1] [expr $index2-1] ]
        }
    }
    
    return $expID
}




###########################################
# returns a list of files
proc QueryForProjectFiles { } {
    set fileNameList ""

    # see if experiment already exists & do error checking on response.
    set xml [exec $::XNAT(client) -host $::XNAT(host) -user_session $::XNAT(sessionID) -m GET -remote /REST/projects/$::XNAT(project)/files?format=xml]
    if { [ErrorCheckOnResponse $xml] == 1 } {
        puts "...>>>>>>ERROR: Query for project files returned error."
        return $fileNameList
    }

    # response starts first column in each new row with file name
    # parse for all project files between "<row><cell>" and "</cell>"
    set count 0
    set index [ string first "\<row\>\<cell\>" $xml ]
    while { $index >= 0 } {
        set snippingIndex1 $index
        set snippingIndex2 [ string first "\<\/cell\>" $xml $snippingIndex1 ]
        if { $snippingIndex2 >= 0 } {
            set snip [ string range $xml [expr $snippingIndex1 + 10] [expr $snippingIndex2 - 1] ]
            set snip [ string trim $snip ">"]
            set snip [ string trim $snip "<"]
            lappend fileNameList $snip
            set index [ string first "\<row\>\<cell\>" $xml [expr $index+1]]
        } else {
            break
        }
    }
    return $fileNameList
}





###########################################
# returns a list of files
proc QueryForSessionFiles { subjectID experimentLabel } {

    set fileNameList ""
    
    if { $subjectID == "" } {
        puts "...>>>>>>ERROR: Got a NULL subjectID. No query was made."
        return
    }
    if {$experimentLabel == "" } {
        puts "...>>>>>>ERROR: Got a NULL MRsession label. No query was made."
        return
    }
    set expID [ QueryForExperimentID $subjectID $experimentLabel ]
    if { $expID <= 0} {
        puts "...>>>>>>ERROR: Could not find experimentID for label $experimentLabel. No query was made."
        return
    }

    # see if experiment already exists & do error checking on response.
    set xml [exec $::XNAT(client) -host $::XNAT(host) -user_session $::XNAT(sessionID) -m GET -remote /REST/projects/$::XNAT(project)/subjects/$subjectID/experiments/$expID/resources/sessionFiles/files?format=xml]
    if { [ErrorCheckOnResponse $xml] > 0 } {
        puts "...>>>>>>ERROR: Query for session files returned error."
        return $fileNameList
    }

    #parse for all project files between "<row><cell>" and "</cell>"
    set count 0
    set index [ string first "\<row\>\<cell\>" $xml ]
    while { $index >= 0 } {
        set snippingIndex1 $index
        set snippingIndex2 [ string first "\<\/cell\>" $xml $snippingIndex1 ]
        if { $snippingIndex2 >= 0 } {
            set snip [ string range $xml [expr $snippingIndex1 + 10] [expr $snippingIndex2 - 1] ]
            set snip [ string trim $snip ">"]
            set snip [ string trim $snip "<"]
            lappend fileNameList $snip
            set index [ string first "\<row\>\<cell\>" $xml [expr $index+1]]
        } else {
            break
        }
    }

    if { $::XNAT(verbose)} {
        puts "$fileNameList"
    }

    # return a list of files
    return $fileNameList
}



###########################################
# interface to XNATRestClient to add a new subject 
# return 1 if id is unique, 0 if scan is already found -1 if error
proc QueryForUniqueScanID { subjectID expID scanID } {

    if { $subjectID == "" } {
        puts "...>>>>>>ERROR: Got a NULL subjectID."
        return -1
    }
    if {$expID == "" } {
        puts "...>>>>>>ERROR: Got a NULL MRsession ID."
        return -1
    }
    
    set xml [exec $::XNAT(client) -host $::XNAT(host) -user_session $::XNAT(sessionID) -m PUT -remote "/REST/projects/$::XNAT(project)/subjects/$subjectID/experiments/$expID/scans?format=xml"]
    if { [ErrorCheckOnResponse $xml] == 1 } {
        puts "...>>>>>>ERROR: Got error message instead of resource ID from remote PUT of $filename."
    } 

    # search for <cell>$ID</cell>
    if { [ string first "\<cell\>$scanID\<\/cell\>" $xml ] >= 0 } {
        return 0
    } 

    return 1
}




###########################################
proc QueryForSubjectByAgeRangeInYears { yearsMin yearsMax } {

    # not done.
    set xml [ exec $::XNAT(client) ...] 
    # parse this to get subjects
    # return subject list.
    return $subjectIDList

}



