
###########################################
# create an XNAT remote session; avoids authentication at each transaction
proc CreateXNATSession { uid password} {

    if { $uid == "" || $password == "" } {
        puts "...>>>>>>ERROR: user name and/or password are not set. XNAT session not created."
        exit 1
    }
    
    if { $::XNAT(verbose) } {
        puts "...Creating XNAT session"        
    }

    set ::XNAT(sessionID) [exec $::XNAT(client) -host $::XNAT(host) -u $uid -p $password -m POST -remote /REST/JSESSION]
    if { $::XNAT(sessionID) == "" } {
        puts "...>>>>>>ERROR: Couldn't establish session connection to $::XNAT(host)"
        exit 1
    }

    if { $::XNAT(verbose) } {
        puts "...got xnat sessionID = $::XNAT(sessionID)"
    }

    # XNAT transaction shortcuts. Edit  if API changes
    set ::XNATquery(GETPrefix) "-host $::XNAT(host) -user_session $::XNAT(sessionID) -m GET -remote /REST/projects/"
    set ::XNATquery(subjectPrefix) "$::XNATquery(GETPrefix)$::XNAT(project)/subjects/"

    set ::XNATupload(POSTPrefix) "-host $::XNAT(host) -user_session $::XNAT(sessionID) -m POST -remote /REST/projects/"
    set ::XNATupload(PUTPrefix) "-host $::XNAT(host) -user_session $::XNAT(sessionID) -m PUT -remote /REST/projects/"
    set ::XNATupload(PUTforSubjectPrefix) "$::XNATupload(PUTPrefix)subjects/"
}



