###########################################
# stupidly simple error check. 
# return 1 if error is found, 0 if no error, 2 if NULL
# (sometimes NULL response from server is OK!)
proc ErrorCheckOnResponse {responseString } {


   #--- got nothing.
    if { $responseString == "" } {
        #puts "...>>>>>>WARNING (but maybe OK): Got a NULL response from XNAT host."
        return 2
    }
    
    if { [string first "The server has not found" $responseString 0] >= 0  } {
        puts "...>>>>>>WARNING: No results were found on the server."
        return 1
    }

    if { [string first "ConnectException" $responseString 0] >= 0  } {
        puts "...>>>>>>ERROR: The XNAT session expired. Got error from server."
        return 1
    }

    #--- got help message
    if { [string first "XNAT REST Client Web Service" $responseString  0] >= 0  } {
        puts "...>>>>>>ERROR: Got usage response from XNAT host."
        return 1
    }

    #--- got error message
    if {  [string first "ERROR CODE" $responseString  0] >= 0  } {
        puts "...>>>>>>ERROR: Got error response from XNAT host."
        return 1
    }

    #--- maybe a good response
    return 0
}

