/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class DefaultDocletTag
implements DocletTag {
    private final String name;
    private final String value;
    private final int lineNumber;
    private final JavaSource javaSource;
    private String[] parameters;
    private Map namedParameters;
    private String[] quotes = new String[]{"\"", "'"};

    public DefaultDocletTag(String name, String value, int lineNumber, JavaSource javaSource) {
        this.name = name;
        this.value = value;
        this.lineNumber = lineNumber;
        this.javaSource = javaSource;
    }

    public DefaultDocletTag(String name, String value) {
        this(name, value, 0, null);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String[] getParameters() {
        if (this.parameters == null) {
            ArrayList<String> paramsList = new ArrayList<String>();
            StringTokenizer tokens = new StringTokenizer(this.value);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                for (int i = 0; i < this.quotes.length; ++i) {
                    String quote = this.quotes[i];
                    if (token.indexOf(quote) == -1) continue;
                    while (!token.endsWith(quote)) {
                        if (!tokens.hasMoreTokens()) continue;
                        token = token + " " + tokens.nextToken();
                    }
                    break;
                }
                paramsList.add(token);
            }
            this.parameters = new String[paramsList.size()];
            paramsList.toArray(this.parameters);
        }
        return this.parameters;
    }

    public String getNamedParameter(String key) {
        if (this.namedParameters == null) {
            this.namedParameters = new HashMap();
            String[] params = this.getParameters();
            for (int i = 0; i < params.length; ++i) {
                String param = params[i];
                int eq = param.indexOf(61);
                if (eq <= -1) continue;
                String k = param.substring(0, eq);
                String v = param.substring(eq + 1);
                v = this.trim(v, this.quotes);
                if (k.length() <= 0) continue;
                this.namedParameters.put(k, v);
            }
        }
        return (String)this.namedParameters.get(key);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public JavaSource getJavaSource() {
        return this.javaSource;
    }

    private String trim(String value, String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            while (value.startsWith(string)) {
                value = value.substring(string.length(), value.length());
            }
            while (value.endsWith(string)) {
                value = value.substring(0, value.length() - string.length());
            }
        }
        return value;
    }
}

