/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.AbstractInheritableJavaEntity;
import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.IndentBuffer;
import com.thoughtworks.qdox.model.JavaClassCache;
import com.thoughtworks.qdox.model.JavaClassParent;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaClass
extends AbstractInheritableJavaEntity
implements JavaClassParent {
    private static Type OBJECT = new Type("java.lang.Object");
    private List methods = new LinkedList();
    private JavaMethod[] methodsArray;
    private List fields = new LinkedList();
    private JavaField[] fieldsArray;
    private List classes = new LinkedList();
    private JavaClass[] classesArray;
    private boolean interfce;
    private Type type;
    private Type superClass;
    private Type[] implementz = new Type[0];
    private JavaClassParent parent;
    private JavaClassCache javaClassCache;

    public JavaClass(JavaClassParent parent) {
        this.parent = parent;
    }

    public void setJavaClassCache(JavaClassCache javaClassCache) {
        this.javaClassCache = javaClassCache;
        OBJECT = javaClassCache.getClassByName("java.lang.Object").asType();
    }

    public boolean isInterface() {
        return this.interfce;
    }

    public Type getSuperClass() {
        boolean iAmJavaLangObject = OBJECT.equals(this.asType());
        if (!this.interfce && this.superClass == null && !iAmJavaLangObject) {
            return OBJECT;
        }
        return this.superClass;
    }

    public JavaClass getSuperJavaClass() {
        if (this.getSuperClass() != null) {
            return this.getSuperClass().getJavaClass();
        }
        return null;
    }

    public Type[] getImplements() {
        return this.implementz;
    }

    public JavaClass[] getImplementedInterfaces() {
        Type[] type = this.getImplements();
        JavaClass[] result = new JavaClass[type.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = type[i].getJavaClass();
        }
        return result;
    }

    protected void writeBody(IndentBuffer result) {
        this.writeAccessibilityModifier(result);
        this.writeNonAccessibilityModifiers(result);
        result.write(this.interfce ? "interface " : "class ");
        result.write(this.name);
        if (this.superClass != null) {
            result.write(" extends ");
            result.write(this.superClass.getValue());
        }
        if (this.implementz.length > 0) {
            result.write(this.interfce ? " extends " : " implements ");
            for (int i = 0; i < this.implementz.length; ++i) {
                if (i > 0) {
                    result.write(", ");
                }
                result.write(this.implementz[i].getValue());
            }
        }
        result.write(" {");
        result.newline();
        result.indent();
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            JavaField javaField = (JavaField)iterator.next();
            result.newline();
            javaField.write(result);
        }
        iterator = this.methods.iterator();
        while (iterator.hasNext()) {
            JavaMethod javaMethod = (JavaMethod)iterator.next();
            result.newline();
            javaMethod.write(result);
        }
        iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            result.newline();
            javaClass.write(result);
        }
        result.deindent();
        result.newline();
        result.write('}');
        result.newline();
    }

    public void setInterface(boolean interfce) {
        this.interfce = interfce;
    }

    public void addMethod(JavaMethod meth) {
        this.methods.add(meth);
        meth.setParentClass(this);
        this.methodsArray = null;
    }

    public void setSuperClass(Type type) {
        this.superClass = type;
    }

    public void setImplementz(Type[] implementz) {
        this.implementz = implementz;
    }

    public void addField(JavaField javaField) {
        this.fields.add(javaField);
        javaField.setParentClass(this);
        this.fieldsArray = null;
    }

    public JavaClassParent getParent() {
        return this.parent;
    }

    public JavaSource getParentSource() {
        JavaClassParent parent = this.getParent();
        return parent == null ? null : parent.getParentSource();
    }

    public String getPackage() {
        return this.getParentSource().getPackage();
    }

    public String getFullyQualifiedName() {
        String pakkage = this.getParent().asClassNamespace();
        char separator = this.isInner() ? (char)'$' : '.';
        return pakkage == null ? this.getName() : pakkage + separator + this.getName();
    }

    public boolean isInner() {
        return this.getParent() instanceof JavaClass;
    }

    public String resolveType(String typeName) {
        JavaClass[] innerClasses = this.getInnerClasses();
        for (int i = 0; i < innerClasses.length; ++i) {
            JavaClass innerClass = innerClasses[i];
            String innerName = innerClass.getFullyQualifiedName();
            if (!innerName.endsWith(typeName)) continue;
            return innerName;
        }
        return this.parent.resolveType(typeName);
    }

    public ClassLibrary getClassLibrary() {
        return this.parent.getClassLibrary();
    }

    public String asClassNamespace() {
        return this.getFullyQualifiedName();
    }

    public Type asType() {
        if (this.type == null) {
            this.type = new Type(this.getFullyQualifiedName(), 0, this);
        }
        return this.type;
    }

    public JavaMethod[] getMethods() {
        if (this.methodsArray == null) {
            this.methodsArray = new JavaMethod[this.methods.size()];
            this.methods.toArray(this.methodsArray);
        }
        return this.methodsArray;
    }

    public JavaMethod[] getMethods(boolean superclasses) {
        if (superclasses) {
            HashSet signatures = new HashSet();
            ArrayList methods = new ArrayList();
            this.addMethodsFromSuperclassAndInterfaces(signatures, methods, this);
            return methods.toArray(new JavaMethod[methods.size()]);
        }
        return this.getMethods();
    }

    private void addMethodsFromSuperclassAndInterfaces(Set signatures, List methodList, JavaClass clazz) {
        JavaMethod[] methods = clazz.getMethods();
        this.addNewMethods(signatures, methodList, methods);
        JavaClass superclass = clazz.getSuperJavaClass();
        if (superclass != null && superclass != clazz) {
            this.addMethodsFromSuperclassAndInterfaces(signatures, methodList, superclass);
        }
        JavaClass[] implementz = clazz.getImplementedInterfaces();
        for (int i = 0; i < implementz.length; ++i) {
            this.addMethodsFromSuperclassAndInterfaces(signatures, methodList, implementz[i]);
        }
    }

    private void addNewMethods(Set signatures, List methodList, JavaMethod[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            String signature;
            JavaMethod method = methods[i];
            if (method.isPrivate() || signatures.contains(signature = method.getDeclarationSignature(false))) continue;
            methodList.add(method);
            signatures.add(signature);
        }
    }

    public JavaMethod getMethodBySignature(String name, Type[] parameterTypes) {
        JavaMethod[] methods = this.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].signatureMatches(name, parameterTypes)) continue;
            return methods[i];
        }
        return null;
    }

    public JavaMethod getMethodBySignature(String name, Type[] parameterTypes, boolean superclasses) {
        JavaMethod[] result = this.getMethodsBySignature(name, parameterTypes, superclasses);
        return result.length > 0 ? result[0] : null;
    }

    public JavaMethod[] getMethodsBySignature(String name, Type[] parameterTypes, boolean superclasses) {
        ArrayList<JavaMethod> result = new ArrayList<JavaMethod>();
        JavaMethod methodInThisClass = this.getMethodBySignature(name, parameterTypes);
        if (methodInThisClass != null) {
            result.add(methodInThisClass);
        }
        if (superclasses) {
            JavaMethod method;
            JavaClass superclass = this.getSuperJavaClass();
            if (superclass != null && (method = superclass.getMethodBySignature(name, parameterTypes, true)) != null && !method.isPrivate()) {
                result.add(method);
            }
            JavaClass[] implementz = this.getImplementedInterfaces();
            for (int i = 0; i < implementz.length; ++i) {
                JavaMethod method2 = implementz[i].getMethodBySignature(name, parameterTypes, true);
                if (method2 == null) continue;
                result.add(method2);
            }
        }
        return result.toArray(new JavaMethod[result.size()]);
    }

    public JavaField[] getFields() {
        if (this.fieldsArray == null) {
            this.fieldsArray = new JavaField[this.fields.size()];
            this.fields.toArray(this.fieldsArray);
        }
        return this.fieldsArray;
    }

    public JavaField getFieldByName(String name) {
        JavaField[] fields = this.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(name)) continue;
            return fields[i];
        }
        return null;
    }

    public void addClass(JavaClass cls) {
        this.classes.add(cls);
        this.classesArray = null;
    }

    public JavaClass[] getClasses() {
        return this.getInnerClasses();
    }

    public JavaClass[] getInnerClasses() {
        if (this.classesArray == null) {
            this.classesArray = new JavaClass[this.classes.size()];
            this.classes.toArray(this.classesArray);
        }
        return this.classesArray;
    }

    public JavaClass getInnerClassByName(String name) {
        JavaClass[] classes = this.getInnerClasses();
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].getName().equals(name)) continue;
            return classes[i];
        }
        return null;
    }

    public boolean isA(String fullClassName) {
        Type type = new Type(fullClassName, 0, this);
        return this.asType().isA(type);
    }

    public boolean isA(JavaClass javaClass) {
        return this.asType().isA(javaClass.asType());
    }

    public BeanProperty[] getBeanProperties() {
        return this.getBeanProperties(false);
    }

    public BeanProperty[] getBeanProperties(boolean superclasses) {
        Map beanPropertyMap = this.getBeanPropertyMap(superclasses);
        Collection beanPropertyCollection = beanPropertyMap.values();
        return beanPropertyCollection.toArray(new BeanProperty[beanPropertyCollection.size()]);
    }

    private Map getBeanPropertyMap(boolean superclasses) {
        JavaMethod[] methods = this.getMethods(superclasses);
        HashMap beanPropertyMap = new HashMap();
        for (int i = 0; i < methods.length; ++i) {
            BeanProperty beanProperty;
            String propertyName;
            JavaMethod method = methods[i];
            if (method.isPropertyAccessor()) {
                propertyName = method.getPropertyName();
                beanProperty = this.getOrCreateProperty(beanPropertyMap, propertyName);
                beanProperty.setAccessor(method);
                beanProperty.setType(method.getPropertyType());
                continue;
            }
            if (!method.isPropertyMutator()) continue;
            propertyName = method.getPropertyName();
            beanProperty = this.getOrCreateProperty(beanPropertyMap, propertyName);
            beanProperty.setMutator(method);
            beanProperty.setType(method.getPropertyType());
        }
        return beanPropertyMap;
    }

    private BeanProperty getOrCreateProperty(Map beanPropertyMap, String propertyName) {
        BeanProperty result = (BeanProperty)beanPropertyMap.get(propertyName);
        if (result == null) {
            result = new BeanProperty(propertyName);
            beanPropertyMap.put(propertyName, result);
        }
        return result;
    }

    public BeanProperty getBeanProperty(String propertyName) {
        return this.getBeanProperty(propertyName, false);
    }

    public BeanProperty getBeanProperty(String propertyName, boolean superclasses) {
        return (BeanProperty)this.getBeanPropertyMap(superclasses).get(propertyName);
    }

    public JavaClass[] getDerivedClasses() {
        ArrayList<JavaClass> result = new ArrayList<JavaClass>();
        JavaDocBuilder builder = (JavaDocBuilder)this.javaClassCache;
        JavaClass[] classes = builder.getClasses();
        for (int i = 0; i < classes.length; ++i) {
            JavaClass clazz = classes[i];
            if (!clazz.isA(this) || clazz == this) continue;
            result.add(clazz);
        }
        return result.toArray(new JavaClass[result.size()]);
    }

    public DocletTag[] getTagsByName(String name, boolean superclasses) {
        ArrayList result = new ArrayList();
        this.addTagsRecursive(result, this, name, superclasses);
        return result.toArray(new DocletTag[result.size()]);
    }

    private void addTagsRecursive(List result, JavaClass javaClass, String name, boolean superclasses) {
        DocletTag[] tags = javaClass.getTagsByName(name);
        this.addNewTags(result, tags);
        if (superclasses) {
            JavaClass superclass = this.getSuperJavaClass();
            if (superclass != null && superclass != javaClass) {
                this.addTagsRecursive(result, superclass, name, superclasses);
            }
            JavaClass[] implementz = this.getImplementedInterfaces();
            for (int h = 0; h < implementz.length; ++h) {
                this.addTagsRecursive(result, superclass, name, superclasses);
            }
        }
    }

    private void addNewTags(List list, DocletTag[] tags) {
        for (int i = 0; i < tags.length; ++i) {
            DocletTag superTag = tags[i];
            if (list.contains(superTag)) continue;
            list.add(superTag);
        }
    }
}

