/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.AbstractInheritableJavaEntity;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.IndentBuffer;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import java.beans.Introspector;
import java.util.ArrayList;

public class JavaMethod
extends AbstractInheritableJavaEntity {
    protected Type returns;
    private JavaParameter[] parameters = JavaParameter.EMPTY_ARRAY;
    private Type[] exceptions = Type.EMPTY_ARRAY;
    private boolean constructor;
    private JavaClass parentClass;

    public Type getReturns() {
        return this.returns;
    }

    public JavaParameter[] getParameters() {
        return this.parameters;
    }

    public JavaParameter getParameterByName(String name) {
        JavaParameter[] parameters = this.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].getName().equals(name)) continue;
            return parameters[i];
        }
        return null;
    }

    public Type[] getExceptions() {
        return this.exceptions;
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    protected void writeBody(IndentBuffer result) {
        this.writeBody(result, true, true, true);
    }

    protected void writeBody(IndentBuffer result, boolean withModifiers, boolean isDeclaration, boolean isPrettyPrint) {
        int i;
        if (withModifiers) {
            this.writeAccessibilityModifier(result);
            this.writeNonAccessibilityModifiers(result);
        }
        if (!this.constructor && isDeclaration) {
            result.write(this.returns.toString());
            result.write(' ');
        }
        result.write(this.name);
        result.write('(');
        for (i = 0; i < this.parameters.length; ++i) {
            JavaParameter parameter = this.parameters[i];
            if (i > 0) {
                result.write(", ");
            }
            if (isDeclaration) {
                result.write(parameter.getType().toString());
                result.write(' ');
            }
            result.write(parameter.getName());
        }
        result.write(')');
        if (isDeclaration && this.exceptions.length > 0) {
            result.write(" throws ");
            for (i = 0; i < this.exceptions.length; ++i) {
                if (i > 0) {
                    result.write(", ");
                }
                result.write(this.exceptions[i].getValue());
            }
        }
        if (isPrettyPrint) {
            result.write(';');
            result.newline();
        }
    }

    private String getSignature(boolean withModifiers, boolean isDeclaration) {
        IndentBuffer result = new IndentBuffer();
        this.writeBody(result, withModifiers, isDeclaration, false);
        return result.toString();
    }

    public String getDeclarationSignature(boolean withModifiers) {
        return this.getSignature(withModifiers, true);
    }

    public String getCallSignature() {
        return this.getSignature(false, false);
    }

    public void setReturns(Type returns) {
        this.returns = returns;
    }

    public void setParameters(JavaParameter[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i].setParentMethod(this);
        }
        this.parameters = parameters;
    }

    public void setExceptions(Type[] exceptions) {
        this.exceptions = exceptions;
    }

    public void setConstructor(boolean constructor) {
        this.constructor = constructor;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        JavaMethod m = (JavaMethod)obj;
        if (m.isConstructor() != this.isConstructor()) {
            return false;
        }
        if (m.getName() == null) {
            return this.getName() == null;
        }
        if (!m.getName().equals(this.getName())) {
            return false;
        }
        if (m.getReturns() == null) {
            return this.getReturns() == null;
        }
        if (!m.getReturns().equals(this.getReturns())) {
            return false;
        }
        JavaParameter[] myParams = this.getParameters();
        JavaParameter[] otherParams = m.getParameters();
        if (otherParams.length != myParams.length) {
            return false;
        }
        for (int i = 0; i < myParams.length; ++i) {
            if (otherParams[i].equals(myParams[i])) continue;
            return false;
        }
        return true;
    }

    public boolean signatureMatches(String name, Type[] parameterTypes) {
        if (!name.equals(this.name)) {
            return false;
        }
        Type[] typeArray = parameterTypes = parameterTypes == null ? new Type[]{} : parameterTypes;
        if (parameterTypes.length != this.parameters.length) {
            return false;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.parameters[i].getType().equals(parameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.name.hashCode();
        if (this.returns != null) {
            hashCode *= this.returns.hashCode();
        }
        return hashCode *= this.getParameters().length;
    }

    public JavaClass getParentClass() {
        return this.parentClass;
    }

    public void setParentClass(JavaClass parentClass) {
        this.parentClass = parentClass;
    }

    public boolean isPublic() {
        return super.isPublic() || this.parentClass.isInterface();
    }

    public boolean isPropertyAccessor() {
        boolean result = false;
        if (this.isPublic() && !this.isStatic()) {
            boolean signatureOk = false;
            boolean nameOk = false;
            if (this.getName().startsWith("is")) {
                String returnType = this.getReturns().getValue();
                signatureOk = returnType.equals("boolean") || returnType.equals("java.lang.Boolean");
                boolean bl = signatureOk = signatureOk && this.getReturns().getDimensions() == 0;
                if (this.getName().length() > 2) {
                    nameOk = Character.isUpperCase(this.getName().charAt(2));
                }
            }
            if (this.getName().startsWith("get")) {
                signatureOk = true;
                if (this.getName().length() > 3) {
                    nameOk = Character.isUpperCase(this.getName().charAt(3));
                }
            }
            boolean noParams = this.getParameters().length == 0;
            result = signatureOk && nameOk && noParams;
        }
        return result;
    }

    public boolean isPropertyMutator() {
        boolean nameOk = false;
        if (this.getName().startsWith("set") && this.getName().length() > 3) {
            nameOk = Character.isUpperCase(this.getName().charAt(3));
        }
        boolean oneParam = this.getParameters().length == 1;
        return nameOk && oneParam;
    }

    public Type getPropertyType() {
        Type result = null;
        result = this.isPropertyAccessor() ? this.getReturns() : (this.isPropertyMutator() ? this.getParameters()[0].getType() : null);
        return result;
    }

    public String getPropertyName() {
        int start = -1;
        if (this.getName().startsWith("get") || this.getName().startsWith("set")) {
            start = 3;
        } else if (this.getName().startsWith("is")) {
            start = 2;
        } else {
            return null;
        }
        return Introspector.decapitalize(this.getName().substring(start));
    }

    public DocletTag[] getTagsByName(String name, boolean inherited) {
        JavaClass clazz = this.getParentClass();
        JavaParameter[] params = this.getParameters();
        Type[] types = new Type[params.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = params[i].getType();
        }
        JavaMethod[] methods = clazz.getMethodsBySignature(this.getName(), types, true);
        ArrayList<DocletTag> result = new ArrayList<DocletTag>();
        for (int i = 0; i < methods.length; ++i) {
            JavaMethod method = methods[i];
            DocletTag[] tags = method.getTagsByName(name);
            for (int j = 0; j < tags.length; ++j) {
                DocletTag tag = tags[j];
                if (result.contains(tag)) continue;
                result.add(tag);
            }
        }
        return result.toArray(new DocletTag[result.size()]);
    }
}

