/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassParent;
import java.io.Serializable;

public class Type
implements Comparable,
Serializable {
    public static final Type[] EMPTY_ARRAY = new Type[0];
    private String name;
    private JavaClassParent javaClassParent;
    private String fullName;
    private int dimensions;

    public Type(String name, int dimensions, JavaClassParent javaClassParent) {
        this.name = name;
        this.dimensions = dimensions;
        this.javaClassParent = javaClassParent;
    }

    public Type(String fullName, int dimensions) {
        this.fullName = fullName;
        this.dimensions = dimensions;
    }

    public Type(String fullName) {
        this(fullName, 0);
    }

    public JavaClassParent getJavaClassParent() {
        return this.javaClassParent;
    }

    public String getValue() {
        return this.isResolved() ? this.fullName : this.name;
    }

    public boolean isResolved() {
        if (this.fullName == null && this.javaClassParent != null) {
            this.fullName = this.javaClassParent.resolveType(this.name);
        }
        return this.fullName != null;
    }

    public int compareTo(Object o) {
        if (!(o instanceof Type)) {
            return 0;
        }
        return this.getValue().compareTo(((Type)o).getValue());
    }

    public boolean isArray() {
        return this.dimensions > 0;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public String toString() {
        if (this.dimensions == 0) {
            return this.getValue();
        }
        StringBuffer buff = new StringBuffer(this.getValue());
        for (int i = 0; i < this.dimensions; ++i) {
            buff.append("[]");
        }
        String result = buff.toString();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Type t = (Type)obj;
        return this.getValue().equals(t.getValue()) && t.getDimensions() == this.getDimensions();
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public JavaClass getJavaClass() {
        JavaClassParent javaClassParent = this.getJavaClassParent();
        if (javaClassParent == null) {
            return null;
        }
        ClassLibrary classLibrary = javaClassParent.getClassLibrary();
        if (classLibrary == null) {
            return null;
        }
        return classLibrary.getClassByName(this.getValue());
    }

    public boolean isA(Type type) {
        if (this.equals(type)) {
            return true;
        }
        JavaClass javaClass = this.getJavaClass();
        if (javaClass != null) {
            Type[] implementz = javaClass.getImplements();
            for (int i = 0; i < implementz.length; ++i) {
                if (!implementz[i].isA(type)) continue;
                return true;
            }
            Type supertype = javaClass.getSuperClass();
            if (supertype != null && supertype.isA(type)) {
                return true;
            }
        }
        return false;
    }
}

