/*
 * Decompiled with CFR 0.152.
 */
package dart;

import dart.server.Container;
import dart.server.Project;
import dart.server.Server;
import dart.server.Version;
import java.io.File;
import java.net.URL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class DartServer
extends Container {
    static Logger logger = Logger.getLogger(class$dart$DartServer == null ? (class$dart$DartServer = DartServer.class$("dart.DartServer")) : class$dart$DartServer);
    CommandLine cmd = null;
    static String helpString = "DartServer [options] Server.xml <Project0.xml> <Project1.xml> ... <ProjectN.xml>";
    static Server server;
    static /* synthetic */ Class class$dart$DartServer;

    public static void main(String[] args) {
        String[] otherargs;
        server = null;
        CommandLine cmd = DartServer.parseCommandLine(args);
        if (cmd.hasOption("h")) {
            new HelpFormatter().printHelp(helpString, DartServer.getOptions());
            System.exit(0);
        }
        URL logConfigurationFile = (class$dart$DartServer == null ? (class$dart$DartServer = DartServer.class$("dart.DartServer")) : class$dart$DartServer).getClassLoader().getResource("dart/Resources/Server/log4j.properties");
        if (cmd.hasOption("l")) {
            try {
                logConfigurationFile = new File(cmd.getOptionValue("l")).toURL();
            }
            catch (Exception e) {
                logger.error("Error in log4j configuration file name", e);
                System.exit(1);
            }
        }
        PropertyConfigurator.configure(logConfigurationFile);
        logger.info("Starting DartServer version " + Version.getVersionString() + " db version " + Version.getDBVersionString());
        String[] keys = new String[]{"java.class.version", "java.vendor", "java.vendor.url", "java.version", "os.arch", "os.name", "os.version"};
        for (int i = 0; i < keys.length; ++i) {
            logger.info("JVM " + keys[i] + ": " + System.getProperty(keys[i]));
        }
        logger.info("Initialized log4j from " + logConfigurationFile.toString());
        if (cmd.hasOption("c")) {
            try {
                Project.createProject(cmd.getOptionValue("c"), cmd.getOptionValue("d", "derby"), cmd.getOptionValue("t", null));
                System.exit(0);
            }
            catch (Exception e) {
                logger.error("Failed to create Project: ", e);
                System.exit(1);
            }
        }
        if (cmd.hasOption("k")) {
            try {
                Server.createServer(cmd.getOptionValue("k", "DartServer"), cmd.getOptionValue("d", "derby"));
                System.exit(0);
            }
            catch (Exception e) {
                logger.error("Failed to create user database: ", e);
                System.exit(1);
            }
        }
        if ((otherargs = cmd.getArgs()).length == 0) {
            new HelpFormatter().printHelp(helpString, DartServer.getOptions());
            System.exit(0);
        }
        server = Server.loadServer(otherargs[0]);
        if (otherargs.length > 1) {
            server.clearProjects();
            for (int i = 1; i < otherargs.length; ++i) {
                server.addProject(otherargs[i]);
            }
        }
        logger.info("Server name: " + server.getTitle());
        logger.info("Server directory: " + server.getBaseDirectory());
        try {
            server.getDatabase().start(server);
            if (cmd.hasOption("j")) {
                server.initializeDatabase();
                System.exit(0);
            }
        }
        catch (Exception e) {
            logger.error("Error initializing Dart server database");
        }
        if (cmd.hasOption("i")) {
            server.setInitializeProjectDB(true);
        }
        if (cmd.hasOption("r")) {
            server.setRefreshProjectResources(true);
        }
        if (cmd.hasOption("a")) {
            server.setDumpProject(true);
        }
        if (cmd.hasOption("R")) {
            server.setRefreshServerResources(true);
        }
        if (cmd.hasOption("u")) {
            server.setUpgradeProjectDB(true);
        }
        try {
            server.start();
        }
        catch (Exception e) {
            logger.fatal("Failed to start DartServer see previous messages");
            System.exit(0);
        }
    }

    public static Options getOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "Print help message");
        options.addOption("r", "refresh", false, "Refresh project resources");
        options.addOption("a", "archive", false, "Archive the project");
        options.addOption("R", "refreshServer", false, "Refresh server resources");
        options.addOption("l", "logconfiguration", true, "File to configure log4j from, defaults are used if not present");
        options.addOption("c", "create", true, "Create a new project in the directory specified");
        options.addOption("d", "database", true, "At project creation time, configure the Schema.sql file for generic, Postgres, Derby");
        options.addOption("i", "initialize", false, "Initialize the database from the Schema.sql file in the project directory");
        options.addOption("k", "createserver", true, "Create a new server in the directory specified");
        options.addOption("j", "initializeserver", false, "Initialize the database from the ServerSchema.sql file in the dart server directory");
        options.addOption("t", "projecttemplate", true, "Create a new Project using the specified default template: dart/Resources/Server/DartDefault.xml in the jar file is the default");
        options.addOption("u", "upgradeprojectdb", false, "Update all Project's databases to the lastest version");
        return options;
    }

    public static CommandLine parseCommandLine(String[] args) {
        Options options = DartServer.getOptions();
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (Exception e) {
            System.out.println("Failed to parse commandline: " + e + "\n");
            new HelpFormatter().printHelp(helpString, options);
            System.exit(1);
        }
        return cmd;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

