/*
 * Decompiled with CFR 0.152.
 */
package dart.server.listener;

import dart.server.MessengerManager;
import dart.server.Project;
import dart.server.event.SubmissionEvent;
import dart.server.listener.Listener;
import dart.server.messenger.Messenger;
import dart.server.wrap.SubmissionEntity;
import dart.server.wrap.SubmissionFinderBase;
import dart.server.wrap.TestEntity;
import dart.server.wrap.TestIterator;
import dart.server.wrap.TestList;
import dart.server.wrap.UserEntity;
import dart.server.wrap.UserFinderBase;
import dart.server.wrap.UserPropertyEntity;
import dart.server.wrap.UserPropertyFinderBase;
import dart.server.wrap.UserPropertyIterator;
import dart.server.wrap.UserPropertyList;
import java.sql.Connection;
import java.util.HashSet;
import java.util.Iterator;
import net.sourceforge.jaxor.JaxorContextImpl;
import org.apache.log4j.Logger;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpServer;

public class SubmissionErrorsListener
extends Listener {
    static Logger logger = Logger.getLogger(class$dart$server$listener$SubmissionErrorsListener == null ? (class$dart$server$listener$SubmissionErrorsListener = SubmissionErrorsListener.class$("dart.server.listener.SubmissionErrorsListener")) : class$dart$server$listener$SubmissionErrorsListener);
    static /* synthetic */ Class class$dart$server$listener$SubmissionErrorsListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void trigger(Project project, SubmissionEvent event) throws Exception {
        block25: {
            logger.info("Submission event for SubmissionId " + event.getSubmissionId());
            MessengerManager messengerManager = project.getMessengerManager();
            Messenger messenger = messengerManager.getMessenger(this.properties.getProperty("Messenger"));
            logger.info("Retrieved messenger " + this.properties.getProperty("Messenger") + "(" + messenger + ")");
            if (messenger == null) {
                logger.warn("No messenger specified.");
                return;
            }
            Connection connection = project.getConnection();
            JaxorContextImpl dbSession = new JaxorContextImpl(connection);
            SubmissionFinderBase submissionFinder = new SubmissionFinderBase(dbSession);
            Connection serverConnection = project.getServer().getConnection();
            JaxorContextImpl serverDBSession = new JaxorContextImpl(serverConnection);
            UserFinderBase userFinder = new UserFinderBase(serverDBSession);
            UserPropertyFinderBase userPropertyFinder = new UserPropertyFinderBase(serverDBSession);
            SubmissionEntity submission = submissionFinder.selectBySubmissionId(new Long(event.getSubmissionId()));
            if (submission != null && submission.getErrorCount().longValue() > 0L) {
                TestList tlist;
                HashSet<String> authorList = new HashSet<String>();
                TestEntity update = submission.selectTest(".Update.Update");
                if (update != null && (tlist = update.selectChildren()).size() > 0) {
                    TestIterator tit = tlist.iterator();
                    TestEntity updatedFile = null;
                    while (tit.hasNext()) {
                        updatedFile = tit.next();
                        String author = updatedFile.getResultValue("Author", "");
                        if (author.equals("")) continue;
                        authorList.add(author);
                    }
                }
                HashSet<String> emailList = new HashSet<String>();
                UserEntity user = null;
                UserPropertyEntity up = null;
                UserPropertyList uplist = null;
                String propertyName = project.getTitle() + ".RepositoryId";
                Iterator ait = authorList.iterator();
                while (ait.hasNext()) {
                    String author = (String)ait.next();
                    uplist = userPropertyFinder.selectByNameValueList(propertyName, author);
                    if (uplist.size() <= 0) continue;
                    UserPropertyIterator upit = uplist.iterator();
                    while (upit.hasNext()) {
                        up = upit.next();
                        user = userFinder.selectByUserId(up.getUserId());
                        emailList.add(user.getEmail());
                    }
                }
                HashSet<String> defaultContactList = new HashSet<String>();
                if (this.properties.containsKey("DefaultContactList")) {
                    String[] defaultList = this.properties.getProperty("DefaultContactList").split(",");
                    for (int i = 0; i < defaultList.length; ++i) {
                        defaultContactList.add(defaultList[i]);
                    }
                }
                String subject = "Dart(" + project.getTitle() + ") - " + submission.getSite() + " - " + submission.getBuildName() + " - " + submission.getType() + " - " + submission.getTimeStamp() + " - " + submission.getErrorCount() + " errors";
                HttpServer httpServer = project.getHttpServer();
                HttpContext httpContext = httpServer.getContext("/" + project.getTitle() + "/*");
                String cp = httpContext.getContextPath();
                String url = "http://" + project.getServer().getServerName() + cp + "/Dashboard/Submission?submissionid=" + submission.getSubmissionId();
                String content = new String();
                content = "A submission to the Dart server for project \"" + project.getTitle() + "\" has build errors. You have been identified as one of the authors who have checked in changes that are part of this submission or you are listed in the default contact list.  Details on the submission can be found at " + url + "\n\n";
                content = content + "Project: " + project.getTitle() + "\n" + "Site: " + submission.getSite() + "\n" + "BuildName: " + submission.getBuildName() + "\n" + "Type: " + submission.getType() + "\n" + "Errors: " + submission.getErrorCount() + "\n" + "Warnings: " + submission.getWarningCount() + "\n" + "\n\n";
                TestList firstErrorsPerStage = submission.selectTestListLike(".Build.Stage%.Error");
                TestIterator errorIt = firstErrorsPerStage.iterator();
                while (errorIt.hasNext()) {
                    TestEntity error = errorIt.next();
                    TestEntity parent = error.selectParent();
                    content = content + "First error for stage " + parent.getResultValue("StageName", "(Unkown)") + ": \n" + "File: " + error.getResultValue("SourceFile", "(Unknown)") + "\n" + "Line: " + error.getResultValue("SourceLineNumber", "(Unknown)") + "\n" + error.getResultValue("PreContext", "") + "\n" + error.getResultValue("Text", "") + "\n" + error.getResultValue("PostContext", "") + "\n\n";
                }
                content = content + "- Dart server on " + project.getServer().getServerName();
                try {
                    messenger.send(emailList, defaultContactList, subject, content);
                }
                catch (Exception e) {
                    logger.error("Error sending notification: " + e);
                }
            }
            Object var33_35 = null;
            try {
                logger.debug("Closing connection.");
                project.closeConnection(connection);
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                logger.debug("Closing connection.");
                project.getServer().closeConnection(serverConnection);
            }
            catch (Exception e2) {}
            break block25;
            {
                catch (Exception e) {
                    Object var33_36 = null;
                    try {
                        logger.debug("Closing connection.");
                        project.closeConnection(connection);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        logger.debug("Closing connection.");
                        project.getServer().closeConnection(serverConnection);
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var33_37 = null;
                try {
                    logger.debug("Closing connection.");
                    project.closeConnection(connection);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    logger.debug("Closing connection.");
                    project.getServer().closeConnection(serverConnection);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

