/*
 * Decompiled with CFR 0.152.
 */
package dart.server.messenger;

import com.sun.net.ssl.internal.ssl.Provider;
import dart.server.messenger.Messenger;
import java.security.Security;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;

public class SMTPMessenger
extends Messenger {
    static Logger logger = Logger.getLogger(class$dart$server$messenger$SMTPMessenger == null ? (class$dart$server$messenger$SMTPMessenger = SMTPMessenger.class$("dart.server.messenger.SMTPMessenger")) : class$dart$server$messenger$SMTPMessenger);
    static /* synthetic */ Class class$dart$server$messenger$SMTPMessenger;

    public void send(Collection recipients, Collection defaultContacts, String subject, String message) throws Exception {
        Session mailSession = null;
        SMTPMessengerAuthenticator authenticator = null;
        if (this.properties.getProperty("mail.smtp.auth") != null && this.properties.getProperty("mail.smtp.auth").equals("true") || this.properties.getProperty("mail.smtps.auth") != null && this.properties.getProperty("mail.smtps.auth").equals("true")) {
            authenticator = new SMTPMessengerAuthenticator(this.properties);
            mailSession = Session.getDefaultInstance(this.properties, authenticator);
        } else {
            mailSession = Session.getDefaultInstance(this.properties, null);
        }
        if (this.properties.getProperty("mail.smtp.starttls.enable") != null && this.properties.getProperty("mail.smtp.startls.enable").equals("true")) {
            Security.addProvider((java.security.Provider)new Provider());
        }
        MimeMessage msg = new MimeMessage(mailSession);
        msg.setFrom(new InternetAddress(this.properties.getProperty("mail.from")));
        Iterator rit = recipients.iterator();
        while (rit.hasNext()) {
            msg.addRecipient(Message.RecipientType.TO, new InternetAddress((String)rit.next()));
        }
        rit = defaultContacts.iterator();
        while (rit.hasNext()) {
            msg.addRecipient(Message.RecipientType.CC, new InternetAddress((String)rit.next()));
        }
        msg.setSubject(subject);
        msg.setText(message);
        try {
            Transport.send(msg);
        }
        catch (AuthenticationFailedException ae) {
            logger.error("Authentication exception. Unable to send notification. " + ae);
        }
        catch (SendFailedException se) {
            int i;
            String errorMsg = new String();
            errorMsg = errorMsg + "Send failed exception. Unable to completely send notification.\n\n";
            Address[] addresses = se.getValidSentAddresses();
            errorMsg = errorMsg + "\tValid sent addresses: ";
            if (addresses != null) {
                for (i = 0; i < addresses.length; ++i) {
                    if (i > 0) {
                        errorMsg = errorMsg + ", ";
                    }
                    errorMsg = errorMsg + addresses[i];
                }
                errorMsg = errorMsg + "\n";
            } else {
                errorMsg = errorMsg + "(none).\n";
            }
            addresses = se.getInvalidAddresses();
            errorMsg = errorMsg + "\tInvalid addresses: ";
            if (addresses != null) {
                for (i = 0; i < addresses.length; ++i) {
                    if (i > 0) {
                        errorMsg = errorMsg + ", ";
                    }
                    errorMsg = errorMsg + addresses[i];
                }
                errorMsg = errorMsg + "\n";
            } else {
                errorMsg = errorMsg + "(none).\n";
            }
            addresses = se.getValidUnsentAddresses();
            errorMsg = errorMsg + "\tValid unsent addresses: ";
            if (addresses != null) {
                for (i = 0; i < addresses.length; ++i) {
                    if (i > 0) {
                        errorMsg = errorMsg + ", ";
                    }
                    errorMsg = errorMsg + addresses[i];
                }
                errorMsg = errorMsg + "\n";
            } else {
                errorMsg = errorMsg + "(none).\n";
            }
            logger.error(errorMsg);
            try {
                Address[] validUnsent = se.getValidUnsentAddresses();
                if (validUnsent != null && validUnsent.length != 0) {
                    msg.setRecipients(Message.RecipientType.TO, validUnsent);
                    Transport.send(msg);
                }
            }
            catch (SendFailedException se2) {
                logger.error("Second chance failure to send notification. " + se2);
            }
        }
        catch (MessagingException me) {
            logger.error("Messaging exception. Unable to send notification. " + me);
        }
        catch (Exception e) {
            logger.error("Unable to send notification. " + e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SMTPMessengerAuthenticator
    extends Authenticator {
        Properties properties = null;

        public SMTPMessengerAuthenticator(Properties p) {
            this.properties = p;
        }

        public void setProperties(Properties p) {
            this.properties = p;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            String user = null;
            String password = null;
            if (this.properties != null) {
                user = this.properties.getProperty("mail.user");
                if (this.properties.getProperty("mail.smtp.user") != null) {
                    user = this.properties.getProperty("mail.smtp.user");
                }
                if (this.properties.getProperty("mail.smtps.user") != null) {
                    user = this.properties.getProperty("mail.smtps.user");
                }
                password = this.properties.getProperty("mail.password");
                if (this.properties.getProperty("mail.smtp.password") != null) {
                    password = this.properties.getProperty("mail.smtp.password");
                }
                if (this.properties.getProperty("mail.smtps.password") != null) {
                    password = this.properties.getProperty("mail.smtps.password");
                }
                if (user != null && password != null) {
                    return new PasswordAuthentication(user, password);
                }
            }
            return null;
        }
    }
}

