/*
 * Decompiled with CFR 0.152.
 */
package dart.server.servlet;

import dart.server.Project;
import dart.server.Server;
import dart.server.wrap.ClientEntity;
import dart.server.wrap.ClientFinderBase;
import dart.server.wrap.ClientPropertyEntity;
import dart.server.wrap.ClientPropertyFinderBase;
import dart.server.wrap.ClientPropertyList;
import dart.server.wrap.UserEntity;
import dart.server.wrap.UserFinderBase;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.servlet.HttpSessionHashModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sourceforge.jaxor.EntityNotFoundException;
import net.sourceforge.jaxor.JaxorContextImpl;
import net.sourceforge.jaxor.QueryParams;
import net.sourceforge.jaxor.mappers.LongMapper;
import net.sourceforge.jaxor.mappers.StringMapper;
import net.sourceforge.jaxor.util.SystemException;
import org.apache.log4j.Logger;
import org.mortbay.http.UserRealm;

public class Admin
extends HttpServlet {
    static Logger logger = Logger.getLogger(class$dart$server$servlet$Admin == null ? (class$dart$server$servlet$Admin = Admin.class$("dart.server.servlet.Admin")) : class$dart$server$servlet$Admin);
    static /* synthetic */ Class class$dart$server$servlet$Admin;

    void error(PrintWriter out, String title, String msg, HashMap map) {
        String projectName = (String)map.get("projectName");
        out.println("<html><head><title>" + title + "</title></head>");
        out.println("<body>");
        out.println("<h1>Administration for ");
        out.println(projectName);
        out.println("</h1>");
        out.println("<p>");
        out.println(msg);
        out.println("<p>");
        out.println("</body>");
        out.println("</html>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter out;
        block35: {
            Project project;
            String templateName = req.getPathInfo();
            if (templateName == null) {
                res.sendRedirect(req.getRequestURL() + "/");
                return;
            }
            if (templateName.equals("/")) {
                RequestDispatcher dispatcher = req.getRequestDispatcher("Admin");
                dispatcher.forward(req, res);
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("request", req);
            map.put("response", res);
            res.setContentType("text/html");
            out = res.getWriter();
            map.put("out", out);
            String projectName = this.getInitParameter("project");
            map.put("projectName", projectName);
            try {
                project = Server.getProject(projectName);
                if (project == null) {
                    logger.debug(project.getTitle() + ": not found");
                    this.error(out, "Dart Administration", "Dart: no project found matching \"" + projectName + "\"", map);
                    out.close();
                    return;
                }
            }
            catch (Exception e) {
                logger.debug(projectName + ": error getting project");
                this.error(out, "Dart Administration", "Dart: Error accessing project \"" + projectName + "\"", map);
                out.close();
                return;
            }
            map.put("project", project);
            Connection connection = project.getConnection();
            try {
                connection.setReadOnly(true);
            }
            catch (Exception e) {
                logger.error(project.getTitle() + ": Could not set connection to ReadOnly, possible security hole!", e);
            }
            JaxorContextImpl jaxorContext = new JaxorContextImpl(connection);
            ClientFinderBase clientFinder = new ClientFinderBase(jaxorContext);
            Connection serverConnection = project.getServer().getConnection();
            JaxorContextImpl serverJaxorContext = new JaxorContextImpl(serverConnection);
            UserFinderBase userFinder = new UserFinderBase(serverJaxorContext);
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("serverName", project.getServer().getTitle());
            root.put("projectName", projectName);
            root.put("projectProperties", project.getProperties());
            root.put("request", req);
            root.put("clientFinder", clientFinder);
            root.put("userFinder", userFinder);
            BeansWrapper realmWrapper = new BeansWrapper();
            realmWrapper.setExposureLevel(0);
            try {
                root.put("realm", realmWrapper.wrap(project.getHttpServer().getRealm("Dart")));
            }
            catch (Exception e) {
                // empty catch block
            }
            Map parameters = req.getParameterMap();
            root.put("parameters", parameters);
            BeansWrapper wrapper = new BeansWrapper();
            wrapper.setExposureLevel(0);
            try {
                root.put("writableParameters", wrapper.wrap(new HashMap(parameters)));
            }
            catch (Exception e) {
                logger.error(project.getTitle() + ": Could not wrap map", e);
                this.error(out, "Dart Administration", "Dart: Failed to wrap parameters", map);
                return;
            }
            HttpSession httpSession = req.getSession(false);
            if (httpSession != null) {
                HttpSessionHashModel httpSessionModel = new HttpSessionHashModel(httpSession, ObjectWrapper.DEFAULT_WRAPPER);
                root.put("session", httpSessionModel);
            }
            Date date = new Date();
            root.put("date", date);
            if (parameters.containsKey("clientid")) {
                String[] ids = (String[])parameters.get("clientid");
                ClientEntity client = null;
                try {
                    client = clientFinder.selectByClientId(new Long(ids[0]));
                    root.put("client", client);
                }
                catch (Exception e) {
                    logger.error("Client not found. id = " + ids[0]);
                }
            }
            try {
                this.findTemplate(map);
            }
            catch (Exception e) {
                logger.error("Failed to find template", e);
                this.error(out, "Dart Administration", "Dart: Failed to find or parse template: \"" + (String)map.get("templateName") + "\"", map);
                try {
                    project.closeConnection(connection);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    project.getServer().closeConnection(serverConnection);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                out.close();
                return;
            }
            Template template = (Template)map.get("template");
            template.process(root, out);
            Object var24_32 = null;
            try {
                project.closeConnection(connection);
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                project.getServer().closeConnection(serverConnection);
            }
            catch (Exception e2) {}
            break block35;
            {
                catch (Exception e) {
                    Object var24_33 = null;
                    try {
                        project.closeConnection(connection);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        project.getServer().closeConnection(serverConnection);
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var24_34 = null;
                try {
                    project.closeConnection(connection);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    project.getServer().closeConnection(serverConnection);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        out.close();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Map parameters = req.getParameterMap();
        String command = req.getPathInfo();
        String projectName = this.getInitParameter("project");
        Project project = Server.getProject(projectName);
        UserRealm realm = project.getHttpServer().getRealm("Dart");
        HttpSession httpSession = req.getSession();
        if (parameters.get("AddClientProperty") != null) {
            logger.debug("Adding a client property");
            if (!parameters.containsKey("clientid")) {
                logger.info("No clientid specified, redirect somewhere.");
                res.sendRedirect(req.getContextPath() + req.getServletPath() + req.getPathInfo() + "?" + req.getQueryString());
                return;
            }
            Principal principal = (Principal)httpSession.getAttribute("user");
            if (realm.isUserInRole(principal, "Dart.Administrator") || realm.isUserInRole(principal, projectName + ".Administrator")) {
                Connection connection = project.getConnection();
                JaxorContextImpl dbSession = new JaxorContextImpl(connection);
                ClientPropertyFinderBase clientPropertyFinder = new ClientPropertyFinderBase(dbSession);
                Connection serverConnection = project.getServer().getConnection();
                JaxorContextImpl serverJaxorContext = new JaxorContextImpl(serverConnection);
                UserFinderBase userFinder = new UserFinderBase(serverJaxorContext);
                String propertyName = ((String[])parameters.get("PropertyName"))[0];
                String propertyValue = ((String[])parameters.get("PropertyValue"))[0];
                String[] ids = (String[])parameters.get("clientid");
                ClientPropertyEntity cp = null;
                if (propertyName != null) {
                    if (propertyName.startsWith("Expected.") && propertyName.endsWith(".Notify.UserId")) {
                        try {
                            UserEntity user = userFinder.selectByEmail(propertyValue);
                            propertyValue = new String(user.getUserId().toString());
                        }
                        catch (EntityNotFoundException exc) {
                            logger.error("User to notify cannot be located.");
                            try {
                                project.closeConnection(connection);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            try {
                                project.getServer().closeConnection(serverConnection);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            res.sendRedirect(req.getContextPath() + req.getServletPath() + req.getPathInfo() + "?" + req.getQueryString());
                            return;
                        }
                    }
                    QueryParams qc = new QueryParams();
                    qc.add(new LongMapper(), (Object)new Long(ids[0]));
                    qc.add(new StringMapper(), (Object)propertyName);
                    qc.add(new StringMapper(), (Object)propertyValue);
                    ClientPropertyList propertyList = clientPropertyFinder.find("where clientid=? and name=? and value=?", qc);
                    if (propertyList.size() > 0) {
                        logger.info("Client property already exists.");
                        try {
                            project.closeConnection(connection);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            project.getServer().closeConnection(serverConnection);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        res.sendRedirect(req.getContextPath() + req.getServletPath() + req.getPathInfo() + "?" + req.getQueryString());
                        return;
                    }
                    cp = clientPropertyFinder.newInstance();
                    cp.setClientId(new Long(ids[0]));
                    cp.setName(propertyName);
                    cp.setValue(propertyValue);
                    try {
                        dbSession.commit();
                    }
                    catch (SystemException e) {
                        logger.error("Failed to update client property. " + e.getCauseList());
                    }
                    propertyList = clientPropertyFinder.selectByClientIdList(new Long(ids[0]));
                }
                try {
                    project.closeConnection(connection);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    project.getServer().closeConnection(serverConnection);
                }
                catch (Exception e) {
                    // empty catch block
                }
                res.sendRedirect(req.getContextPath() + req.getServletPath() + req.getPathInfo() + "?" + req.getQueryString());
            }
        } else if (parameters.get("RemoveClientProperty") != null) {
            logger.debug("Removing a client property");
            if (!parameters.containsKey("clientid")) {
                logger.info("No clientid specified, redirect somewhere.");
                res.sendRedirect(req.getContextPath() + req.getServletPath() + req.getPathInfo() + "?" + req.getQueryString());
                return;
            }
            Principal principal = (Principal)httpSession.getAttribute("user");
            if (realm.isUserInRole(principal, "Dart.Administrator") || realm.isUserInRole(principal, projectName + ".Administrator")) {
                Connection connection = project.getConnection();
                JaxorContextImpl dbSession = new JaxorContextImpl(connection);
                ClientPropertyFinderBase clientPropertyFinder = new ClientPropertyFinderBase(dbSession);
                Connection serverConnection = project.getServer().getConnection();
                JaxorContextImpl serverJaxorContext = new JaxorContextImpl(serverConnection);
                UserFinderBase userFinder = new UserFinderBase(serverJaxorContext);
                String propertyName = ((String[])parameters.get("PropertyName"))[0];
                String propertyValue = ((String[])parameters.get("PropertyValue"))[0];
                String[] ids = (String[])parameters.get("clientid");
                ClientPropertyEntity cp = null;
                if (propertyName != null) {
                    if (propertyName.startsWith("Expected.") && propertyName.endsWith(".Notify.UserId")) {
                        try {
                            UserEntity user = userFinder.selectByEmail(propertyValue);
                            propertyValue = new String(user.getUserId().toString());
                        }
                        catch (EntityNotFoundException exc) {
                            logger.error("User to notify cannot be located.");
                            try {
                                project.closeConnection(connection);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            try {
                                project.getServer().closeConnection(serverConnection);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            res.sendRedirect(req.getContextPath() + req.getServletPath() + req.getPathInfo() + "?" + req.getQueryString());
                            return;
                        }
                    }
                    QueryParams qc = new QueryParams();
                    qc.add(new LongMapper(), (Object)new Long(ids[0]));
                    qc.add(new StringMapper(), (Object)propertyName);
                    qc.add(new StringMapper(), (Object)propertyValue);
                    ClientPropertyList propertyList = clientPropertyFinder.find("where clientid=? and name=? and value=?", qc);
                    if (propertyList.size() > 0) {
                        cp = (ClientPropertyEntity)propertyList.toList().get(0);
                        cp.delete();
                    }
                    try {
                        dbSession.commit();
                    }
                    catch (SystemException e) {
                        logger.error("Failed to update client property. " + e.getCauseList());
                    }
                    ClientPropertyList properties = clientPropertyFinder.selectByClientIdList(new Long(ids[0]));
                }
                try {
                    project.closeConnection(connection);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    project.getServer().closeConnection(serverConnection);
                }
                catch (Exception e) {
                    // empty catch block
                }
                res.sendRedirect(req.getContextPath() + req.getServletPath() + req.getPathInfo() + "?" + req.getQueryString());
            }
        }
    }

    void findTemplate(HashMap map) throws Exception {
        HttpServletRequest request = (HttpServletRequest)map.get("request");
        Project project = (Project)map.get("project");
        String templateName = request.getPathInfo();
        map.put("templateName", templateName);
        Configuration cfg = new Configuration();
        File resourcesDirectory = new File(project.getBaseDirectory(), "Templates");
        cfg.setDirectoryForTemplateLoading(resourcesDirectory);
        Template template = cfg.getTemplate(templateName + ".ftl");
        map.put("template", template);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

