/*
 * Decompiled with CFR 0.152.
 */
package dart.server.servlet;

import dart.server.Project;
import dart.server.Server;
import dart.server.servlet.FetchData;
import dart.server.wrap.ClientEntity;
import dart.server.wrap.ClientFinderBase;
import dart.server.wrap.ClientList;
import dart.server.wrap.SubmissionEntity;
import dart.server.wrap.SubmissionFinderBase;
import dart.server.wrap.SubmissionList;
import dart.server.wrap.TrackEntity;
import dart.server.wrap.TrackFinderBase;
import dart.server.wrap.TrackList;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.servlet.HttpSessionHashModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sourceforge.jaxor.JaxorContextImpl;
import net.sourceforge.jaxor.QueryParams;
import net.sourceforge.jaxor.mappers.LongMapper;
import net.sourceforge.jaxor.mappers.StringMapper;
import org.apache.log4j.Logger;

public class Dashboard
extends HttpServlet {
    static Logger logger = Logger.getLogger(class$dart$server$servlet$Dashboard == null ? (class$dart$server$servlet$Dashboard = Dashboard.class$("dart.server.servlet.Dashboard")) : class$dart$server$servlet$Dashboard);
    static /* synthetic */ Class class$dart$server$servlet$Dashboard;

    void error(PrintWriter out, String title, String msg, HashMap map) {
        String projectName = (String)map.get("projectName");
        out.println("<html><head><title>" + title + "</title></head>");
        out.println("<body>");
        out.println("<h1>Dashboard for ");
        out.println(projectName);
        out.println("</h1>");
        out.println("<p>");
        out.println(msg);
        out.println("<p>");
        out.println("</body>");
        out.println("</html>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String[] ids;
        Date date;
        String key;
        Project project;
        String templateName = req.getPathInfo();
        if (templateName == null) {
            res.sendRedirect(req.getRequestURL() + "/");
            return;
        }
        if (templateName.equals("/")) {
            RequestDispatcher dispatcher = req.getRequestDispatcher("Dashboard");
            dispatcher.forward(req, res);
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("request", req);
        map.put("response", res);
        if (templateName.endsWith(".xml")) {
            res.setContentType("text/xml");
        } else {
            res.setContentType("text/html");
        }
        PrintWriter out = res.getWriter();
        map.put("out", out);
        String projectName = this.getInitParameter("project");
        map.put("projectName", projectName);
        try {
            project = Server.getProject(projectName);
            if (project == null) {
                logger.debug(project.getTitle() + ": not found");
                this.error(out, "Dart Dashboard", "Dart: no project found matching \"" + projectName + "\"", map);
                out.close();
                return;
            }
        }
        catch (Exception e) {
            logger.debug(projectName + ": error getting project");
            this.error(out, "Dart Dashboard", "Dart: Error accessing project \"" + projectName + "\"", map);
            out.close();
            return;
        }
        map.put("project", project);
        Connection connection = project.getConnection();
        try {
            connection.setReadOnly(true);
        }
        catch (Exception e) {
            logger.error(project.getTitle() + ": Could not set connection to ReadOnly, possible security hole!", e);
        }
        JaxorContextImpl jaxorContext = new JaxorContextImpl(connection);
        SubmissionFinderBase submissionFinder = new SubmissionFinderBase(jaxorContext);
        TrackFinderBase trackFinder = new TrackFinderBase(jaxorContext);
        ClientFinderBase clientFinder = new ClientFinderBase(jaxorContext);
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("serverName", project.getServer().getTitle());
        root.put("projectName", projectName);
        root.put("fetchdata", new FetchData(project));
        root.put("projectProperties", project.getProperties());
        root.put("request", req);
        root.put("submissionFinder", submissionFinder);
        BeansWrapper realmWrapper = new BeansWrapper();
        realmWrapper.setExposureLevel(0);
        try {
            root.put("realm", realmWrapper.wrap(project.getHttpServer().getRealm("Dart")));
        }
        catch (Exception e) {
            // empty catch block
        }
        Map parameters = req.getParameterMap();
        root.put("parameters", parameters);
        BeansWrapper wrapper = new BeansWrapper();
        wrapper.setExposureLevel(0);
        try {
            root.put("writableParameters", wrapper.wrap(new HashMap(parameters)));
        }
        catch (Exception e) {
            logger.error(project.getTitle() + ": Could not wrap map", e);
            this.error(out, "Dart Dashboard", "Dart: Failed to wrap parameters", map);
            return;
        }
        HttpSession httpSession = req.getSession(false);
        if (httpSession != null) {
            HttpSessionHashModel httpSessionModel = new HttpSessionHashModel(httpSession, ObjectWrapper.DEFAULT_WRAPPER);
            root.put("session", httpSessionModel);
        }
        if (parameters.containsKey("trackid")) {
            key = ((String[])parameters.get("trackid"))[0];
            TrackEntity te = trackFinder.selectByPrimaryKey(new Long(key));
            date = new Date(te.getEndTime().getTime() - 1000L);
        } else if (parameters.containsKey("timestamp")) {
            String stamp = ((String[])parameters.get("timestamp"))[0];
            date = project.parseBuildStamp(stamp);
        } else if (parameters.containsKey("submissionid")) {
            key = ((String[])parameters.get("submissionid"))[0];
            SubmissionEntity se = submissionFinder.selectByPrimaryKey(new Long(key));
            date = new Date(se.getTimeStamp().getTime());
        } else {
            date = new Date();
        }
        Date now = new Date();
        if (date.after(now)) {
            date = now;
        }
        String ts = new SimpleDateFormat("yyyyMMdd").format(date);
        root.put("date", date);
        root.put("timestamp", ts);
        Timestamp timeStamp = new Timestamp(date.getTime());
        project.getTrackManager().getTrackIds(timeStamp);
        TrackList trackEntityList = trackFinder.selectIntersectingList(timeStamp, timeStamp);
        root.put("tracks", this.getTrackMap(trackEntityList));
        root.put("defaulttrack", project.getTrackManager().getDefaultTrack());
        root.put("trackorder", project.getTrackManager().getTrackOrder());
        root.put("trackmanager", project.getTrackManager());
        if (parameters.containsKey("submissionid")) {
            ids = (String[])parameters.get("submissionid");
            SubmissionEntity submission = submissionFinder.selectBySubmissionId(new Long(ids[0]));
            root.put("submission", submission);
        } else if (parameters.containsKey("site") && parameters.containsKey("buildname") && parameters.containsKey("track")) {
            QueryParams qc = new QueryParams();
            qc.add(new StringMapper(), (Object)((String[])parameters.get("site"))[0]);
            qc.add(new StringMapper(), (Object)((String[])parameters.get("buildname"))[0]);
            ClientList clist = clientFinder.find("where site = ? and buildname = ?", qc);
            if (clist.size() > 0) {
                ClientEntity c = (ClientEntity)clist.toList().get(0);
                QueryParams qs = new QueryParams();
                qs.add(new StringMapper(), (Object)timeStamp);
                qs.add(new LongMapper(), (Object)c.getClientId());
                qs.add(new StringMapper(), (Object)((String[])parameters.get("track"))[0]);
                SubmissionList slist = submissionFinder.find("where timestamp = ? and clientid = ? and type = ?", qs);
                if (slist.size() > 0) {
                    root.put("submission", (SubmissionEntity)slist.toList().get(0));
                }
            }
        }
        if (parameters.containsKey("clientid")) {
            ids = (String[])parameters.get("clientid");
            ClientEntity client = null;
            try {
                client = clientFinder.selectByClientId(new Long(ids[0]));
                root.put("client", client);
            }
            catch (Exception e) {
                logger.error("Client not found. id = " + ids[0]);
            }
        }
        try {
            this.findTemplate(map);
        }
        catch (Exception e) {
            logger.error("Failed to find template", e);
            this.error(out, "Dart Dashboard", "Dart: Failed to find or parse template: \"" + (String)map.get("templateName") + "\"", map);
            try {
                project.closeConnection(connection);
            }
            catch (Exception e2) {
                // empty catch block
            }
            out.close();
            return;
        }
        try {
            Template template = (Template)map.get("template");
            template.process(root, out);
        }
        catch (Exception e) {
        }
        finally {
            try {
                project.closeConnection(connection);
            }
            catch (Exception e) {}
        }
        out.close();
    }

    HashMap getTrackMap(TrackList trackList) {
        HashMap<String, TrackEntity> trackMap = new HashMap<String, TrackEntity>();
        TrackEntity[] trackArray = trackList.toArray();
        for (int i = 0; i < trackArray.length; ++i) {
            trackMap.put(trackArray[i].getName(), trackArray[i]);
        }
        return trackMap;
    }

    void findTemplate(HashMap map) throws Exception {
        HttpServletRequest request = (HttpServletRequest)map.get("request");
        Project project = (Project)map.get("project");
        String templateName = request.getPathInfo();
        map.put("templateName", templateName);
        Configuration cfg = new Configuration();
        File resourcesDirectory = new File(project.getBaseDirectory(), "Templates");
        cfg.setDirectoryForTemplateLoading(resourcesDirectory);
        Template template = cfg.getTemplate(templateName + ".ftl");
        map.put("template", template);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

