/*
 * Decompiled with CFR 0.152.
 */
package dart.server.servlet;

import dart.server.Project;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModelException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class FetchData
implements TemplateMethodModel {
    Project project;

    public FetchData(Project p) {
        this.project = p;
    }

    public Object exec(List args) throws TemplateModelException {
        if (args.size() != 1) {
            throw new TemplateModelException("usage: <filename>");
        }
        String filename = (String)args.get(0);
        File file = new File(this.project.getDataDirectory() + File.separator + filename);
        if (!file.exists() || !file.canRead()) {
            throw new TemplateModelException("File " + file.toString() + " does not exist or is not readable");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int count;
            FilterInputStream in = new BufferedInputStream(new FileInputStream(file));
            if (filename.endsWith(".gz")) {
                in = new GZIPInputStream(in);
            }
            byte[] buffer = new byte[2048];
            while ((count = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, count);
            }
            ((InputStream)in).close();
            return out.toString();
        }
        catch (Exception e) {
            throw new TemplateModelException("Failed to read file", e);
        }
    }
}

