/*
 * Decompiled with CFR 0.152.
 */
package dart.server.task;

import dart.server.Project;
import dart.server.event.MissingSubmissionEvent;
import dart.server.task.Task;
import dart.server.wrap.ClientEntity;
import dart.server.wrap.ClientFinderBase;
import dart.server.wrap.ClientPropertyEntity;
import dart.server.wrap.ClientPropertyFinderBase;
import dart.server.wrap.ClientPropertyResultSet;
import dart.server.wrap.ClientResultSet;
import dart.server.wrap.SubmissionFinderBase;
import dart.server.wrap.SubmissionList;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import net.sourceforge.jaxor.JaxorContextImpl;
import org.apache.log4j.Logger;

public class MissingSubmissionTask
implements Task {
    static Logger logger = Logger.getLogger(class$dart$server$task$MissingSubmissionTask == null ? (class$dart$server$task$MissingSubmissionTask = MissingSubmissionTask.class$("dart.server.task.MissingSubmissionTask")) : class$dart$server$task$MissingSubmissionTask);
    static /* synthetic */ Class class$dart$server$task$MissingSubmissionTask;

    public void execute(Project project, Properties properties) throws Exception {
        boolean missing = false;
        ArrayList<Long> clientIds = new ArrayList<Long>();
        HashSet<Long> userIds = new HashSet<Long>();
        Date date = new Date();
        Timestamp timeStamp = new Timestamp(date.getTime());
        String trackName = properties.getProperty("Track");
        Long trackId = new Long(project.getTrackManager().getTrackId(timeStamp, trackName));
        String expectedSubmissionKey = "Expected." + trackName;
        String expectedSubmissionUserKey = expectedSubmissionKey + ".Notify.UserId";
        Connection connection = project.getConnection();
        JaxorContextImpl dbSession = new JaxorContextImpl(connection);
        ClientFinderBase clientFinder = new ClientFinderBase(dbSession);
        ClientPropertyFinderBase clientPropertyFinder = new ClientPropertyFinderBase(dbSession);
        SubmissionFinderBase submissionFinder = new SubmissionFinderBase(dbSession);
        Connection serverConnection = project.getServer().getConnection();
        JaxorContextImpl serverDBSession = new JaxorContextImpl(serverConnection);
        ClientResultSet clientList = clientFinder.selectByClientPropertyResultSet(expectedSubmissionKey, "true");
        while (clientList.hasNext()) {
            ClientEntity client = clientList.next();
            Long clientId = client.getClientId();
            SubmissionList submissionList = submissionFinder.selectByClientIdAndTrackIdList(clientId, trackId);
            if (submissionList.size() != 0) continue;
            missing = true;
            clientIds.add(clientId);
            ClientPropertyEntity cp = null;
            ClientPropertyResultSet who = clientPropertyFinder.selectByClientIdNameResultSet(clientId, expectedSubmissionUserKey);
            while (who.hasNext()) {
                cp = who.next();
                try {
                    Long userid = new Long(Long.parseLong(cp.getValue()));
                    userIds.add(userid);
                }
                catch (NumberFormatException exc) {}
            }
            who.close();
        }
        clientList.close();
        if (missing) {
            MissingSubmissionEvent event = new MissingSubmissionEvent(clientIds, userIds, trackName, trackId);
            project.getListenerManager().triggerEvent(event);
        }
        try {
            logger.debug("Closing connection.");
            project.closeConnection(connection);
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            logger.debug("Closing connection.");
            project.getServer().closeConnection(serverConnection);
        }
        catch (Exception e2) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

