/*
 * Decompiled with CFR 0.152.
 */
package dart.server.task;

import dart.server.Project;
import dart.server.task.Task;
import dart.server.wrap.SubmissionEntity;
import dart.server.wrap.SubmissionFinderBase;
import dart.server.wrap.TestEntity;
import dart.server.wrap.TestFinderBase;
import dart.server.wrap.TestIterator;
import dart.server.wrap.TestList;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import net.sourceforge.jaxor.JaxorContextImpl;
import org.apache.log4j.Logger;

public class SummarizeTests
implements Task {
    static Logger logger = Logger.getLogger(class$dart$server$task$SummarizeTests == null ? (class$dart$server$task$SummarizeTests = SummarizeTests.class$("dart.server.task.SummarizeTests")) : class$dart$server$task$SummarizeTests);
    static /* synthetic */ Class class$dart$server$task$SummarizeTests;

    public HashMap getTestHashMap(SubmissionEntity submission, boolean zero) {
        HashMap<String, TestEntity> map = new HashMap<String, TestEntity>();
        TestList tests = submission.getTestList();
        TestIterator testIterator = tests.iterator();
        while (testIterator.hasNext()) {
            TestEntity test = testIterator.next();
            if (zero) {
                test.setPassedSubTests(new Integer(0));
                test.setFailedSubTests(new Integer(0));
                test.setNotRunSubTests(new Integer(0));
            }
            map.put(test.getQualifiedName(), test);
            logger.debug("Adding test " + test.getQualifiedName());
        }
        return map;
    }

    public void execute(Project project, Properties properties) throws Exception {
        String SubmissionId = properties.getProperty("SubmissionId");
        Connection connection = project.getConnection();
        JaxorContextImpl session = new JaxorContextImpl(connection);
        SubmissionFinderBase submissionFinder = new SubmissionFinderBase(session);
        TestFinderBase testFinder = new TestFinderBase(session);
        SubmissionEntity submission = submissionFinder.selectBySubmissionId(new Long(SubmissionId));
        try {
            TestEntity test;
            HashMap<String, TestEntity> map = this.getTestHashMap(submission, false);
            HashMap<String, TestEntity> newParents = new HashMap<String, TestEntity>();
            Iterator i = map.values().iterator();
            while (i.hasNext()) {
                TestEntity test2 = (TestEntity)i.next();
                String[] components = test2.getQualifiedName().split("\\.");
                String parent = "";
                for (int c = 1; c < components.length; ++c) {
                    TestEntity parentTest = (TestEntity)map.get(parent);
                    if (parentTest == null && !newParents.containsKey(parent)) {
                        logger.debug("Creating parent Test: \"" + parent + "\"");
                        parentTest = testFinder.newInstance();
                        parentTest.setQualifiedName(parent);
                        parentTest.setName(components[c - 1]);
                        parentTest.setStatus("m");
                        parentTest.setSubmissionId(submission.getSubmissionId());
                        newParents.put(parentTest.getQualifiedName(), parentTest);
                    }
                    parent = parent + "." + components[c];
                }
            }
            session.commit();
            session.flush();
            map = new HashMap<String, TestEntity>();
            TestList tests = testFinder.selectBySubmissionIdList(new Long(SubmissionId));
            TestIterator testIterator = tests.iterator();
            while (testIterator.hasNext()) {
                test = testIterator.next();
                test.setPassedSubTests(new Integer(0));
                test.setFailedSubTests(new Integer(0));
                test.setNotRunSubTests(new Integer(0));
                map.put(test.getQualifiedName(), test);
                logger.debug("Adding test " + test.getQualifiedName());
            }
            i = map.values().iterator();
            while (i.hasNext()) {
                test = (TestEntity)i.next();
                logger.debug(project.getTitle() + ": Second fetch for SubmissionId: " + SubmissionId + " found: \"" + test.getQualifiedName() + "\"");
            }
            i = map.values().iterator();
            while (i.hasNext()) {
                test = (TestEntity)i.next();
                String[] components = test.getQualifiedName().split("\\.");
                if (components.length < 1) {
                    logger.error("Skipping test: " + test.getName());
                    continue;
                }
                String parent = "";
                String status = test.getStatus();
                logger.debug(project.getTitle() + ": Processing " + test.getQualifiedName());
                for (int t = 1; t < components.length; ++t) {
                    Integer p;
                    logger.debug(project.getTitle() + ": Parent " + parent);
                    TestEntity parentTest = (TestEntity)map.get(parent);
                    if (parentTest == null) {
                        logger.error("Did not find parent: \"" + parent + "\"");
                        throw new Exception("Did not find parent: " + parent);
                    }
                    test.setParentTestId(parentTest.getTestId());
                    if (status.equals("p")) {
                        p = parentTest.getPassedSubTests();
                        p = new Integer(p + 1);
                        parentTest.setPassedSubTests(p);
                    } else if (status.equals("f")) {
                        p = parentTest.getFailedSubTests();
                        p = new Integer(p + 1);
                        parentTest.setFailedSubTests(p);
                    } else if (status.equals("n")) {
                        p = parentTest.getNotRunSubTests();
                        p = new Integer(p + 1);
                        parentTest.setNotRunSubTests(p);
                    }
                    parent = parent + "." + components[t];
                }
            }
            session.commit();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            logger.debug("Closing connection.");
            project.closeConnection(connection);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

