/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownServiceException;
import javax.activation.DataSource;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class MimePartDataSource
implements DataSource,
MessageAware {
    private MimePart part;
    private MessageContext context;
    private static boolean ignoreMultipartEncoding = true;

    public MimePartDataSource(MimePart mimePart) {
        this.part = mimePart;
    }

    public InputStream getInputStream() throws IOException {
        try {
            InputStream inputStream;
            if (this.part instanceof MimeBodyPart) {
                inputStream = ((MimeBodyPart)this.part).getContentStream();
            } else if (this.part instanceof MimeMessage) {
                inputStream = ((MimeMessage)this.part).getContentStream();
            } else {
                throw new MessagingException("Unknown part");
            }
            String string = MimePartDataSource.restrictEncoding(this.part.getEncoding(), this.part);
            if (string != null) {
                return MimeUtility.decode(inputStream, string);
            }
            return inputStream;
        }
        catch (MessagingException messagingException) {
            throw new IOException(messagingException.getMessage());
        }
    }

    private static String restrictEncoding(String string, MimePart mimePart) throws MessagingException {
        if (!ignoreMultipartEncoding || string == null) {
            return string;
        }
        if (string.equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit") || string.equalsIgnoreCase("binary")) {
            return string;
        }
        String string2 = mimePart.getContentType();
        if (string2 == null) {
            return string;
        }
        try {
            ContentType contentType = new ContentType(string2);
            if (contentType.match("multipart/*") || contentType.match("message/*")) {
                return null;
            }
        }
        catch (ParseException parseException) {}
        return string;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException();
    }

    public String getContentType() {
        try {
            return this.part.getContentType();
        }
        catch (MessagingException messagingException) {
            return null;
        }
    }

    public String getName() {
        try {
            if (this.part instanceof MimeBodyPart) {
                return ((MimeBodyPart)this.part).getFileName();
            }
        }
        catch (MessagingException messagingException) {}
        return "";
    }

    public synchronized MessageContext getMessageContext() {
        if (this.context == null) {
            this.context = new MessageContext(this.part);
        }
        return this.context;
    }

    static {
        try {
            String string = System.getProperty("mail.mime.ignoremultipartencoding");
            ignoreMultipartEncoding = string == null || !string.equalsIgnoreCase("false");
        }
        catch (SecurityException securityException) {}
    }
}

