/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jaxor.EntityChange;
import net.sourceforge.jaxor.EntityRow;
import net.sourceforge.jaxor.MetaRow;
import net.sourceforge.jaxor.PrimaryKeySet;
import net.sourceforge.jaxor.api.EntityInterface;
import net.sourceforge.jaxor.api.FieldAdapter;
import net.sourceforge.jaxor.api.JaxorContext;
import net.sourceforge.jaxor.api.ValueChangeListener;
import net.sourceforge.jaxor.impl.DeleteEntityChange;
import net.sourceforge.jaxor.impl.FirstTimeValueChangeListener;
import net.sourceforge.jaxor.impl.InsertEntityChange;
import net.sourceforge.jaxor.impl.UpdateEntityChange;
import net.sourceforge.jaxor.util.ForeignFieldLazyLoader;
import net.sourceforge.jaxor.util.ObjectUtils;

public abstract class AbstractEntity
implements EntityInterface,
ValueChangeListener {
    private MetaRow _metaRow;
    private boolean _isCascadingDelete;
    private boolean _isRegisteredForDelete;

    public void setJaxorContext(JaxorContext conn) {
        this.getFields().setJaxorContext(conn);
    }

    public JaxorContext getJaxorContext() {
        return this.getFields().getJaxorContext();
    }

    public boolean registerChange(Object newValue, Object oldValue, FieldAdapter mapper) {
        if (!ObjectUtils.equals(newValue, oldValue) && this.getJaxorContext() != null) {
            this.registerChange();
            return true;
        }
        return false;
    }

    public void registerChange() {
        this.getJaxorContext().registerUpdate(this);
    }

    public void registerLoad() {
        this.getFields().registerLoad(new FirstTimeValueChangeListener(this));
    }

    public void unregister() {
        this.getFields().unregisterListener(this);
    }

    public void registerDelete() {
        if (!this._isRegisteredForDelete) {
            this.getJaxorContext().registerDelete(this);
            this._isRegisteredForDelete = true;
        }
    }

    public void registerCascadingDelete() {
        if (this._isCascadingDelete) {
            return;
        }
        this.registerDelete();
        this._isCascadingDelete = true;
        try {
            List foreignFields = this.getFields().getForeignFields();
            Iterator iterator = foreignFields.iterator();
            while (iterator.hasNext()) {
                ForeignFieldLazyLoader foreign = (ForeignFieldLazyLoader)iterator.next();
                List entities = foreign.getFieldAsList();
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    EntityInterface entity = (EntityInterface)entityIterator.next();
                    entity.registerCascadingDelete();
                }
            }
            Object var8_7 = null;
            this._isCascadingDelete = false;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this._isCascadingDelete = false;
            throw throwable;
        }
    }

    public void validate() {
        this.getFields().validate();
    }

    public String toString() {
        return this.getFields().toString();
    }

    public int hashCode() {
        return this.getPrimaryKeySet().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EntityInterface) {
            return this.equals((EntityInterface)obj);
        }
        return false;
    }

    public Class getImplementationClass() {
        return this.getClass();
    }

    public boolean equals(EntityInterface enity) {
        if (!this.getImplementationClass().equals(enity.getImplementationClass())) {
            return false;
        }
        PrimaryKeySet pkset = this.getPrimaryKeySet();
        if (pkset.equals(enity.getPrimaryKeySet())) {
            return true;
        }
        return enity == this;
    }

    public PrimaryKeySet getPrimaryKeySet() {
        return this.getFields().getPrimaryKey();
    }

    public void insert() {
        this.execute(new InsertEntityChange(this));
    }

    public void delete() {
        this.execute(new DeleteEntityChange(this));
    }

    public void update() {
        this.execute(new UpdateEntityChange(this));
    }

    private void execute(EntityChange entityChange) {
        Connection connection = this.getJaxorContext().getConnection();
        try {
            entityChange.executeSingleChange(connection);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setMetaRow(MetaRow meta) {
        this._metaRow = meta;
    }

    public MetaRow getMetaRow() {
        return this._metaRow;
    }

    public abstract void setFields(EntityRow var1);

    public abstract EntityRow getFields();
}

