/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import net.sourceforge.jaxor.EntityChange;

public class CommitBatch {
    private final Collection _changes;

    public CommitBatch(Collection changes) {
        this._changes = changes;
    }

    public void execute(Connection conn, boolean batchUpdates) throws SQLException {
        if (!batchUpdates) {
            this.noBatching(conn);
        } else {
            this.batch(conn);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void batch(Connection conn) throws SQLException {
        EntityChange last = null;
        Statement lastStmt = null;
        try {
            Iterator iterator = this._changes.iterator();
            while (iterator.hasNext()) {
                EntityChange entityChange = (EntityChange)iterator.next();
                boolean batching = entityChange.canBatchWithLast(last);
                if (batching) {
                    entityChange.addToBatch((PreparedStatement)lastStmt);
                } else if (lastStmt != null) {
                    lastStmt.executeBatch();
                    lastStmt.close();
                    lastStmt = null;
                }
                if (batching) continue;
                lastStmt = entityChange.execute(conn);
                if (lastStmt != null) {
                    lastStmt.addBatch();
                }
                last = entityChange;
            }
            if (lastStmt != null) {
                lastStmt.executeBatch();
            }
            Object var8_7 = null;
            if (lastStmt == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (lastStmt == null) throw throwable;
            try {
                lastStmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            lastStmt.close();
            return;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void noBatching(Connection conn) throws SQLException {
        Iterator iterator = this._changes.iterator();
        while (iterator.hasNext()) {
            EntityChange entityChange = (EntityChange)iterator.next();
            PreparedStatement stmt = entityChange.execute(conn);
            if (stmt == null) continue;
            stmt.execute();
            stmt.close();
        }
    }
}

