/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import net.sourceforge.jaxor.MetaRow;
import net.sourceforge.jaxor.QueryParams;
import net.sourceforge.jaxor.api.ConnectionFactory;
import net.sourceforge.jaxor.api.EntityInterface;
import net.sourceforge.jaxor.api.FinderAdapter;
import net.sourceforge.jaxor.api.InstanceCache;
import net.sourceforge.jaxor.api.InstanceFactory;
import net.sourceforge.jaxor.api.JaxorContext;
import net.sourceforge.jaxor.api.JaxorTransaction;
import net.sourceforge.jaxor.api.LifeCycleListener;
import net.sourceforge.jaxor.api.MapperRegistry;
import net.sourceforge.jaxor.api.QueryCache;
import net.sourceforge.jaxor.api.QueryResult;
import net.sourceforge.jaxor.api.UnitOfWork;
import net.sourceforge.jaxor.db.SingleConnectionTransaction;
import net.sourceforge.jaxor.impl.InstanceCacheImpl;
import net.sourceforge.jaxor.impl.InstanceFactoryImpl;
import net.sourceforge.jaxor.impl.MapperRegistryImpl;
import net.sourceforge.jaxor.impl.QueryResultImpl;
import net.sourceforge.jaxor.impl.UnitOfWorkImpl;
import net.sourceforge.jaxor.util.MethodCache;
import net.sourceforge.jaxor.util.SystemException;

public class JaxorContextImpl
implements JaxorContext {
    private UnitOfWork _uow;
    private QueryCache _queryCache;
    private InstanceCache _cache;
    private JaxorTransaction _transaction = null;
    private final InstanceFactory _instanceFactory;
    private MapperRegistry _mapperRegistry;
    private String _user;

    public JaxorContextImpl(Connection conn) {
        this(new SingleConnectionTransaction(conn));
    }

    public JaxorContextImpl(ConnectionFactory fact) {
        this(new SingleConnectionTransaction(fact));
    }

    public JaxorContextImpl(JaxorTransaction trans) {
        this(trans, new InstanceCacheImpl(), new MethodCache(), new UnitOfWorkImpl());
    }

    public JaxorContextImpl(JaxorTransaction conn, InstanceCache cache, QueryCache queryCache, UnitOfWork uow) {
        this(conn, cache, queryCache, uow, new InstanceFactoryImpl(), new MapperRegistryImpl());
    }

    public JaxorContextImpl(JaxorTransaction conn, InstanceCache cache, QueryCache queryCache, UnitOfWork uow, InstanceFactory factory, MapperRegistry reg) {
        this._transaction = conn;
        this._cache = cache;
        this._queryCache = queryCache;
        this._uow = uow;
        this._instanceFactory = factory;
        this._mapperRegistry = reg;
    }

    public String getUser() {
        return this._user;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public InstanceFactory getInstanceFactory() {
        return this._instanceFactory;
    }

    public EntityInterface load(ResultSet rs, MetaRow clzz) {
        EntityInterface result = this.createEntity(clzz);
        try {
            result.getFields().load(rs);
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
        EntityInterface cache = this.cache(result);
        if (cache == result || cache == null) {
            result.setJaxorContext(this);
            if (result instanceof LifeCycleListener) {
                ((LifeCycleListener)((Object)result)).afterLoad();
            }
            result.registerLoad();
        }
        return cache;
    }

    public EntityInterface createEntity(MetaRow clzz) {
        EntityInterface entity = this._instanceFactory.createEntity(clzz.getImplClass());
        entity.setMetaRow(clzz);
        return entity;
    }

    private EntityInterface cache(EntityInterface result) {
        return this._cache.updateCache(result);
    }

    public QueryResult query(String sql, MetaRow implClass) {
        return this.query(sql, new QueryParams(), implClass);
    }

    public QueryResult query(String sql, QueryParams args, MetaRow _meta) {
        return new QueryResultImpl(_meta, sql, args, this);
    }

    public void flush() {
        this._queryCache.clear();
        if (this._uow.size() > 0L) {
            Connection connection = this.getConnection();
            try {
                this._uow.flush(connection);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void commit() {
        this.flush();
        this._transaction.commit();
    }

    public void end() {
        if (this._transaction != null) {
            this._transaction.end();
        }
    }

    public Connection getConnection() {
        Connection conn = this._transaction.getConnection();
        if (conn == null) {
            throw new NullPointerException("JaxorTransaction returned a null connection");
        }
        return conn;
    }

    public InstanceCache getCache() {
        return this._cache;
    }

    public QueryCache getQueryCache() {
        return this._queryCache;
    }

    public UnitOfWork getUnitOfWork() {
        return this._uow;
    }

    public void setCache(InstanceCache cache) {
        this._cache = cache;
    }

    public void setQueryCache(QueryCache cache) {
        this._queryCache = cache;
    }

    public void setUnitOfWork(UnitOfWork work) {
        this._uow = work;
    }

    public void setTransaction(JaxorTransaction fact) {
        this._transaction = fact;
    }

    public JaxorTransaction getTransaction() {
        return this._transaction;
    }

    public MapperRegistry getMapperRegistry() {
        return this._mapperRegistry;
    }

    public void registerNew(EntityInterface entity) {
        if (entity instanceof LifeCycleListener) {
            ((LifeCycleListener)((Object)entity)).beforeCreate();
        }
        entity.setJaxorContext(this);
        this._uow.registerNew(entity);
        if (entity instanceof LifeCycleListener) {
            ((LifeCycleListener)((Object)entity)).afterCreate();
        }
        this.cache(entity);
    }

    public FinderAdapter getFinder(Class finderClass) {
        return this.getInstanceFactory().createFinder(finderClass, this);
    }

    public Object createListImpl(List list, Class listImplClass) {
        return this.getInstanceFactory().createListImpl(list, listImplClass);
    }

    public void registerUpdate(EntityInterface entity) {
        this._uow.registerUpdate(entity);
    }

    public void registerDelete(EntityInterface entity) {
        this._uow.registerDelete(entity);
    }
}

