/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor;

import java.io.Serializable;
import net.sourceforge.jaxor.api.Mapper;
import net.sourceforge.jaxor.util.ObjectUtils;
import net.sourceforge.jaxor.util.SystemException;

public class MetaField
implements Serializable {
    private final String _column;
    private String _property;
    private final boolean _canBeNull;
    private final boolean _primaryKey;
    private final boolean _matchOnUpdate;
    private final boolean _isAutoAssign;
    private final Class _mapperClass;

    public MetaField(String name, String property, boolean canBeNull, boolean primaryKey, boolean matchOnUpdate, boolean isAutoAssign, Class mapperClass) {
        this._column = name;
        this._property = property;
        this._canBeNull = canBeNull;
        this._primaryKey = primaryKey;
        this._matchOnUpdate = matchOnUpdate;
        this._isAutoAssign = isAutoAssign;
        this._mapperClass = mapperClass;
    }

    public MetaField(String name, boolean canBeNull, Class mapper) {
        this(name, null, canBeNull, false, false, false, mapper);
    }

    public boolean isMatchOnUpdate() {
        if (this.isPrimaryKey()) {
            return true;
        }
        return this._matchOnUpdate;
    }

    public boolean isPrimaryKey() {
        return this._primaryKey;
    }

    public String getColumn() {
        return this._column;
    }

    public String getProperty() {
        return this._property;
    }

    public boolean canBeNull() {
        return this._canBeNull;
    }

    public Mapper getMapperInstance() {
        try {
            return (Mapper)this._mapperClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new SystemException(e);
        }
        catch (IllegalAccessException e) {
            throw new SystemException(e);
        }
    }

    public int hashCode() {
        return this._column.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MetaField) {
            return this.equals((MetaField)obj);
        }
        return false;
    }

    public boolean equals(MetaField field) {
        if (!this.getColumn().equals(field.getColumn())) {
            return false;
        }
        if (this.canBeNull() != field.canBeNull()) {
            return false;
        }
        return ObjectUtils.equals(this.getProperty(), field.getProperty());
    }

    public boolean isAutoAssign() {
        return this._isAutoAssign;
    }
}

