/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jaxor.api.Mapper;
import net.sourceforge.jaxor.api.MapperRegistry;
import net.sourceforge.jaxor.mappers.LongMapper;
import net.sourceforge.jaxor.mappers.StringMapper;
import net.sourceforge.jaxor.util.ObjectUtils;
import net.sourceforge.jaxor.util.SystemException;

public class QueryParams {
    private List _params = new ArrayList();

    public void add(int num, Mapper sqlType, Object value) {
        int i = this._params.size();
        while (i <= num) {
            this._params.add(i, null);
            ++i;
        }
        this._params.set(num, new Param(sqlType, value));
    }

    public void add(Mapper sqlType, Object value) {
        this._params.add(new Param(sqlType, value));
    }

    public void add(Object value) {
        this.add(null, value);
    }

    public int hashCode() {
        return this._params.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof QueryParams) {
            QueryParams query = (QueryParams)obj;
            return this._params.equals(query._params);
        }
        return false;
    }

    public String toString() {
        return "Parameters: " + this._params.toString();
    }

    public void setArgs(PreparedStatement stmt, MapperRegistry reg) {
        try {
            int i = 0;
            while (i < this._params.size()) {
                Param p = (Param)this._params.get(i);
                p.setValue(stmt, i + 1, reg);
                ++i;
            }
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
    }

    public void add(int num, Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Argument cannot be null: " + num + " You can pass nulls with mappers");
        }
        this.add(num, null, obj);
    }

    public void addString(String str) {
        this.add(new StringMapper(), (Object)str);
    }

    public void addLong(Long contactId) {
        this.add(new LongMapper(), (Object)contactId);
    }

    public void addString(int num, String str) {
        this.add(num, new StringMapper(), str);
    }

    public void addLong(int num, Long l) {
        this.add(num, new LongMapper(), l);
    }

    public void add(int num, int value) {
        this.add(num, (Object)new Integer(value));
    }

    public void add(int num, long l) {
        this.add(num, (Object)new Long(l));
    }

    public void add(int num, float f) {
        this.add(num, (Object)new Float(f));
    }

    public void add(int num, boolean b) {
        this.add(num, (Object)new Boolean(b));
    }

    public void add(int num, byte b) {
        this.add(num, (Object)new Byte(b));
    }

    public void add(int num, short s) {
        this.add(num, (Object)new Short(s));
    }

    public void add(int num, double d) {
        this.add(num, (Object)new Double(d));
    }

    public void add(int value) {
        this.add(new Integer(value));
    }

    public void add(long l) {
        this.add(new Long(l));
    }

    public void add(float f) {
        this.add(new Float(f));
    }

    public void add(boolean b) {
        this.add(new Boolean(b));
    }

    public void add(byte b) {
        this.add(new Byte(b));
    }

    public void add(short s) {
        this.add(new Short(s));
    }

    public void add(double d) {
        this.add(new Double(d));
    }

    public Object getValue(int count) {
        Param p = (Param)this._params.get(count);
        return p._value;
    }

    public int size() {
        return this._params.size();
    }

    private class Param {
        private Mapper _mapper;
        private final Object _value;

        public Param(Mapper sqlType, Object value) {
            this._mapper = sqlType;
            this._value = value;
        }

        public void setValue(PreparedStatement stmt, int i, MapperRegistry reg) throws SQLException {
            if (this._mapper == null && this._value != null) {
                this._mapper = reg.get(this._value.getClass());
            }
            if (this._mapper == null) {
                throw new SystemException("Mapper not found for parameter: " + i + " Pass a mapper with the parameter, or add a entry to the mapper registry");
            }
            Object mappedValue = this._mapper.mapToSqlObject(this._value);
            int sqlType = this._mapper.getSQLType();
            if (this._value == null) {
                stmt.setNull(i, sqlType);
            } else {
                stmt.setObject(i, mappedValue, sqlType);
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof Param) {
                Param param = (Param)obj;
                return this._mapper == param._mapper && ObjectUtils.equals(this._value, param._value);
            }
            return false;
        }

        public int hashCode() {
            if (this._value == null) {
                return this._mapper.getSQLType();
            }
            return this._value.hashCode();
        }

        public String toString() {
            return this._value == null ? "null" : this._value.toString();
        }
    }
}

