/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jaxor.EntityNotFoundException;
import net.sourceforge.jaxor.EntityRow;
import net.sourceforge.jaxor.MetaField;
import net.sourceforge.jaxor.QueryParams;
import net.sourceforge.jaxor.api.FinderAdapter;

public class ReferenceResolver
implements Serializable {
    private final Class _finderClass;
    private final List _metaRowList = new ArrayList();
    private final boolean _unique;
    private final String _querySql;
    private final String _findSql;
    private final EntityRow _parent;

    public ReferenceResolver(Class finderClass, EntityRow source, boolean unique) {
        this._finderClass = finderClass;
        this._unique = unique;
        this._parent = source;
        this._querySql = null;
        this._findSql = null;
    }

    public ReferenceResolver(Class finderClass, EntityRow source, boolean unique, String querySql, String findSql) {
        this._finderClass = finderClass;
        this._unique = unique;
        this._parent = source;
        this._querySql = querySql;
        this._findSql = findSql;
    }

    public void add(MetaField sourceMeta, MetaField targetMeta) {
        MetaPair pair = new MetaPair();
        pair.Source = sourceMeta;
        pair.Target = targetMeta;
        this._metaRowList.add(pair);
    }

    public List getKeys() {
        return this._metaRowList;
    }

    public Object getObject() {
        if (this._parent == null || this._parent.getJaxorContext() == null) {
            return null;
        }
        FinderAdapter finder = this.createFinder();
        QueryParams params = new QueryParams();
        Iterator iterator = this._metaRowList.iterator();
        while (iterator.hasNext()) {
            MetaPair pair = (MetaPair)iterator.next();
            MetaField source = pair.Source;
            Object value = this.getValue(source.getProperty());
            params.add(source.getMapperInstance(), value);
        }
        if (this._unique) {
            try {
                if (this._querySql != null) {
                    return finder.getFinder().query(this._querySql, params).entity();
                }
                return finder.getFinder().find(this.createFindSql(), params).entity();
            }
            catch (EntityNotFoundException e) {
                return null;
            }
        }
        List list = this.resolveList(finder, params);
        return this._parent.getJaxorContext().createListImpl(list, finder.getFinder().getMetaRow().getListImplClass());
    }

    private List resolveList(FinderAdapter finder, QueryParams params) {
        if (this._querySql != null) {
            return finder.getFinder().query(this._querySql, params).list();
        }
        return finder.getFinder().find(this.createFindSql(), params).list();
    }

    public Object getValue(String propertyName) {
        return this._parent.getPropertyValue(propertyName);
    }

    private FinderAdapter createFinder() {
        return this._parent.getJaxorContext().getFinder(this._finderClass);
    }

    public String createFindSql() {
        if (this._findSql != null) {
            return this._findSql;
        }
        String sql = "where ";
        Iterator iterator = this._metaRowList.iterator();
        while (iterator.hasNext()) {
            MetaPair pair = (MetaPair)iterator.next();
            sql = sql + pair.Target.getColumn() + "=?";
            if (!iterator.hasNext()) continue;
            sql = sql + " AND ";
        }
        return sql;
    }

    public EntityRow getSourceEntity() {
        return this._parent;
    }

    public boolean isUnique() {
        return this._unique;
    }

    public static class MetaPair
    implements Serializable {
        public MetaField Source;
        public MetaField Target;
    }
}

