/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jaxor.ConcurrencyException;
import net.sourceforge.jaxor.EntityNotFoundException;
import net.sourceforge.jaxor.EntityRow;
import net.sourceforge.jaxor.MetaField;
import net.sourceforge.jaxor.MetaRow;
import net.sourceforge.jaxor.SystemSQLException;
import net.sourceforge.jaxor.api.EntityInterface;
import net.sourceforge.jaxor.api.FieldAdapter;
import net.sourceforge.jaxor.api.LifeCycleListener;
import net.sourceforge.jaxor.util.NullProxy;
import net.sourceforge.jaxor.util.SystemException;

public class SqlAdapter
implements Serializable {
    private final MetaRow _meta;
    private final EntityRow _row;
    private final EntityWrapper _entity;
    static /* synthetic */ Class class$net$sourceforge$jaxor$api$LifeCycleListener;

    public SqlAdapter(EntityInterface entity) {
        this(entity.getMetaRow(), entity.getFields(), entity);
    }

    public SqlAdapter(MetaRow row, EntityRow ent, EntityInterface inter) {
        this._meta = row;
        this._row = ent;
        this._entity = inter instanceof LifeCycleListener ? new EntityWrapper(inter, (LifeCycleListener)((Object)inter)) : new EntityWrapper(inter, (LifeCycleListener)NullProxy.create(class$net$sourceforge$jaxor$api$LifeCycleListener == null ? (class$net$sourceforge$jaxor$api$LifeCycleListener = SqlAdapter.class$("net.sourceforge.jaxor.api.LifeCycleListener")) : class$net$sourceforge$jaxor$api$LifeCycleListener));
        if (this._meta == null) {
            throw new NullPointerException("MetaRow is null. Cannot persist entity without metarow. Please set MetaRow on Entity");
        }
    }

    public String insertSQL() {
        return this._meta.getParser().getInsert();
    }

    public String updateSQL() {
        return this._meta.getParser().getUpdate();
    }

    public String deleteSQL() {
        return this._meta.getParser().getDelete();
    }

    public void addToInsertBatch(PreparedStatement stmt) throws SQLException {
        List all = this._meta.getInsertColumns();
        int count = 1;
        Iterator iter = all.iterator();
        while (iter.hasNext()) {
            MetaField element = (MetaField)iter.next();
            FieldAdapter field = this._row.getField(element.getColumn());
            field.addToStatement(stmt, count);
            ++count;
        }
    }

    private void registerLoad() {
        this._entity.Entity.registerLoad();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement getInsertPreparedStatement(Connection conn) throws SQLException {
        PreparedStatement preparedStatement;
        PreparedStatement stmt = conn.prepareStatement(this.insertSQL());
        boolean success = false;
        try {
            this.addToInsertBatch(stmt);
            success = true;
            preparedStatement = stmt;
            Object var6_5 = null;
            if (success) return preparedStatement;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (success) throw throwable;
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            stmt.close();
            return preparedStatement;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return preparedStatement;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insert(Connection conn) {
        PreparedStatement stmt = null;
        stmt = this.getInsertPreparedStatement(conn);
        stmt.execute();
        Object var5_3 = null;
        if (stmt == null) return;
        try {
            stmt.close();
            return;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return;
        {
            catch (SQLException exc) {
                throw new SystemSQLException(exc, this._meta, conn);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (stmt == null) throw throwable;
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
    }

    public void addToDeleteBatch(PreparedStatement stmt) throws SQLException {
        List _pik = this._meta.getPrimaryKey();
        int count = 1;
        Iterator iter = _pik.iterator();
        while (iter.hasNext()) {
            MetaField element = (MetaField)iter.next();
            this._row.getField(element.getColumn()).addToStatement(stmt, count);
            ++count;
        }
    }

    public void beforeInsert() {
        this._entity.Cycle.beforeInsert();
        this._row.notifyFieldsOfInsert(this._entity.Entity.getJaxorContext());
        this.validate();
    }

    public void afterInsert() {
        this._entity.Cycle.afterInsert();
        this.registerLoad();
    }

    public void beforeUpdate() {
        this._entity.Entity.unregister();
        this._entity.Cycle.beforeUpdate();
        this._row.notifyFieldsOfUpdate(this._entity.Entity.getJaxorContext());
        this.validate();
    }

    public void afterUpdate() {
        this.registerLoad();
        this._entity.Cycle.afterUpdate();
    }

    public void beforeDelete() {
        this._entity.Cycle.beforeDelete();
        this._row.notifyFieldsOfDelete(this._entity.Entity.getJaxorContext());
    }

    public void afterDelete() {
        this.getEntity().getJaxorContext().getCache().remove(this.getEntity());
    }

    public void delete(Connection conn) {
        int rows = this.executeDeletion(conn);
        if (rows == 0) {
            throw new EntityNotFoundException();
        }
        if (rows > 1) {
            throw new SystemSQLException("Primary key is not unique");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int executeDeletion(Connection conn) {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = this.getDeletePreparedStatement(conn);
                int n = stmt.executeUpdate();
                Object var5_5 = null;
                if (stmt == null) return n;
                try {
                    stmt.close();
                    return n;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return n;
            }
            catch (SQLException exc) {
                throw new SystemSQLException(exc, this._meta, conn);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (stmt == null) throw throwable;
            try {}
            catch (SQLException e) {
                e.printStackTrace();
                throw throwable;
            }
            stmt.close();
            throw throwable;
        }
    }

    public PreparedStatement getDeletePreparedStatement(Connection conn) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.deleteSQL());
        this.addToDeleteBatch(stmt);
        return stmt;
    }

    /*
     * Loose catch block
     */
    public void update(Connection conn) {
        block9: {
            PreparedStatement stmt = this.createStatement(conn);
            List matchedObjects = this._row.getUpdateMatchValues();
            List update = this._meta.getUpdateColumns();
            int count = 1;
            Iterator iter = update.iterator();
            while (iter.hasNext()) {
                MetaField element = (MetaField)iter.next();
                this._row.getField(element.getColumn()).addToStatement(stmt, count);
                ++count;
            }
            Iterator iter2 = matchedObjects.iterator();
            while (iter2.hasNext()) {
                MatchUpdate element = (MatchUpdate)iter2.next();
                element.update(stmt, count);
                ++count;
            }
            int rows = stmt.executeUpdate();
            this.processUpdates(rows, this._entity.Entity);
            Object var10_11 = null;
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            break block9;
            {
                catch (SQLException exc) {
                    throw new SystemSQLException(exc, this._entity.Entity);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private PreparedStatement createStatement(Connection conn) {
        try {
            return conn.prepareStatement(this.updateSQL());
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
    }

    private void validate() {
        this._entity.Entity.validate();
    }

    private EntityInterface getEntity() {
        return this._entity.Entity;
    }

    protected void processUpdates(int numberOfUpdates, EntityInterface entity) {
        if (numberOfUpdates != 1) {
            throw new ConcurrencyException("Every update should update 1 and only 1 row, not " + numberOfUpdates, entity);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class EntityWrapper
    implements Serializable {
        public final EntityInterface Entity;
        public final LifeCycleListener Cycle;

        public EntityWrapper(EntityInterface entity, LifeCycleListener life) {
            this.Entity = entity;
            this.Cycle = life;
        }
    }

    public static class MatchUpdate
    implements Serializable {
        public Object value;
        public FieldAdapter mapper;

        public void update(PreparedStatement stmt, int param) throws SQLException {
            this.mapper.addToStatement(stmt, param, this.value);
        }
    }
}

