/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.db;

import java.sql.Connection;
import java.sql.SQLException;
import net.sourceforge.jaxor.api.ConnectionFactory;
import net.sourceforge.jaxor.api.JaxorTransaction;
import net.sourceforge.jaxor.db.ConnectionDecorator;
import net.sourceforge.jaxor.util.SystemException;

public class SingleConnectionTransaction
implements JaxorTransaction {
    private transient Connection _conn;
    private ConnectionFactory _factory;

    public SingleConnectionTransaction(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException("Cannot pass a null connection");
        }
        this.setupConnection(conn);
        this._conn = conn;
    }

    public SingleConnectionTransaction(ConnectionFactory fact) {
        this._factory = fact;
    }

    private void setupConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
    }

    public Connection getConnection() {
        return ConnectionDecorator.createNonClosing(this.getConn());
    }

    private Connection getConn() {
        if (this._conn == null) {
            Connection conn = this._factory.getConnection();
            this.setupConnection(conn);
            this._conn = conn;
        }
        return this._conn;
    }

    public void commit() {
        if (this.notUsed()) {
            return;
        }
        try {
            this._conn.commit();
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
    }

    private boolean notUsed() {
        return this._conn == null;
    }

    public void rollback(Exception failure) {
        if (this.notUsed()) {
            return;
        }
        try {
            this._conn.rollback();
        }
        catch (SQLException e) {
            throw new SystemException(failure, (Throwable)e);
        }
    }

    public void end() {
        if (this.notUsed()) {
            return;
        }
        try {
            this._conn.close();
            this._conn = null;
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
    }
}

