/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.generator;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.jaxor.generator.Sql2JavaMapping;
import net.sourceforge.jaxor.parser.Attribute;
import net.sourceforge.jaxor.parser.Entity;
import net.sourceforge.jaxor.parser.EntityRef;
import net.sourceforge.jaxor.parser.Jaxor;
import net.sourceforge.jaxor.parser.Key;
import net.sourceforge.jaxor.parser.PrimaryKey;
import net.sourceforge.jaxor.util.SystemException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class MappingMetaData {
    private Connection _conn;
    private String _catalog;
    private String _schema;
    private Sql2JavaMapping _mapper;
    private RE tableRE;

    public MappingMetaData(Connection conn, String catalog, String schema, Sql2JavaMapping mappings, String tableRegExp) throws RESyntaxException {
        this._conn = conn;
        this._catalog = catalog;
        this._schema = schema;
        this._mapper = mappings;
        this.tableRE = new RE(tableRegExp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Jaxor[] getMapped() {
        DatabaseMetaData databaseMetaData = this.getMetaData();
        ResultSet tables = this.getTableMeta(databaseMetaData);
        try {
            try {
                Jaxor[] jaxorArray = this.processMetadata(tables, databaseMetaData);
                Object var5_5 = null;
                try {
                    tables.close();
                    return jaxorArray;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return jaxorArray;
            }
            catch (SQLException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {}
            catch (SQLException e) {
                e.printStackTrace();
                throw throwable;
            }
            tables.close();
            throw throwable;
        }
    }

    private ResultSet getTableMeta(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.getTables(this.getCatalog(), this.getSchema(), "%", new String[]{"TABLE"});
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
    }

    private DatabaseMetaData getMetaData() {
        try {
            DatabaseMetaData databaseMetaData = this._conn.getMetaData();
            return databaseMetaData;
        }
        catch (SQLException e) {
            throw new SystemException(e);
        }
    }

    private Jaxor[] processMetadata(ResultSet tables, DatabaseMetaData databaseMetaData) throws SQLException {
        ArrayList<Jaxor> jaxors = new ArrayList<Jaxor>();
        while (tables.next()) {
            Jaxor jaxor = new Jaxor();
            String tableName = tables.getString("TABLE_NAME");
            if (!this.shouldProcess(tableName)) continue;
            this.log("processing table " + tableName);
            HashMap attributes = new HashMap();
            this.theColumns(databaseMetaData, tableName, attributes);
            Entity entity = new Entity(tableName);
            this.addPrimaryKeysAndRemoveFromAttributes(databaseMetaData, tableName, entity, attributes);
            this.addImportedKeysAndRemoveFromAttributes(databaseMetaData, tableName, entity, attributes);
            Iterator iterator = attributes.keySet().iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)attributes.get(iterator.next());
                entity.addAttribute(attribute);
            }
            if (entity.getPrimaryKey().getKeys().size() == 0) {
                this.log("warning: table " + tableName + " doesn't define any primary key");
            }
            jaxor.addEntity(entity);
            jaxors.add(jaxor);
        }
        Jaxor[] jaxorsToBeReturned = new Jaxor[jaxors.size()];
        int i = 0;
        while (i < jaxors.size()) {
            Jaxor jaxor;
            jaxorsToBeReturned[i] = jaxor = (Jaxor)jaxors.get(i);
            ++i;
        }
        return jaxorsToBeReturned;
    }

    private boolean shouldProcess(String tableName) {
        return this.tableRE.match(tableName);
    }

    private void addImportedKeysAndRemoveFromAttributes(DatabaseMetaData databaseMetaData, String tableName, Entity entity, Map attributes) throws SQLException {
        ResultSet importedKeys = databaseMetaData.getImportedKeys(this._catalog, this._schema, tableName);
        try {
            while (importedKeys.next()) {
                EntityRef entityRef = new EntityRef();
                entityRef.setTable(importedKeys.getString("PKTABLE_NAME"));
                Key key = new Key();
                key.setSource(importedKeys.getString("FKCOLUMN_NAME"));
                key.setTarget(importedKeys.getString("PKCOLUMN_NAME"));
                entityRef.addKey(key);
                entity.addEntityRef(entityRef);
                attributes.remove(key.getSource());
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            importedKeys.close();
            throw throwable;
        }
        importedKeys.close();
    }

    public String getCatalog() {
        return this._catalog;
    }

    public String getSchema() {
        return this._schema;
    }

    private void addPrimaryKeysAndRemoveFromAttributes(DatabaseMetaData databaseMetaData, String tableName, Entity entity, Map attributes) throws SQLException {
        ResultSet primaryKeys = databaseMetaData.getPrimaryKeys(this.getCatalog(), this.getSchema(), tableName);
        try {
            PrimaryKey primaryKey = new PrimaryKey();
            while (primaryKeys.next()) {
                String name = primaryKeys.getString("COLUMN_NAME");
                Attribute primaryKeyComponent = (Attribute)attributes.remove(name);
                primaryKeyComponent.setName(name);
                primaryKeyComponent.setType(primaryKeyComponent.getType());
                primaryKey.addAttribute(primaryKeyComponent);
            }
            entity.addPrimaryKey(primaryKey);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            primaryKeys.close();
            throw throwable;
        }
        primaryKeys.close();
    }

    private void theColumns(DatabaseMetaData databaseMetaData, String tableName, Map attributes) throws SQLException {
        ResultSet columns = databaseMetaData.getColumns(this.getCatalog(), this.getSchema(), tableName, "%");
        try {
            while (columns.next()) {
                String columnName = columns.getString("COLUMN_NAME");
                int dataType = columns.getInt("DATA_TYPE");
                String dataTypeName = columns.getString("TYPE_NAME");
                String type = this._mapper.getByTypeNameOrCode(dataTypeName, dataType);
                if ("Unknown".equals(type)) {
                    this.logUnknownDataType(dataType, dataTypeName, columnName);
                }
                boolean nullable = "YES".equals(columns.getString("IS_NULLABLE"));
                Attribute attribute = new Attribute(columnName, type, nullable);
                attributes.put(columnName, attribute);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            columns.close();
            throw throwable;
        }
        columns.close();
    }

    protected void logUnknownDataType(int dataType, String dataName, String name) {
        throw new SystemException("warning: unknown sql data type " + dataType + "(" + dataName + ") column: " + name);
    }

    protected void log(String msg) {
    }
}

