/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jaxor.CommitBatch;
import net.sourceforge.jaxor.EntityChange;
import net.sourceforge.jaxor.api.EntityInterface;
import net.sourceforge.jaxor.api.UnitOfWork;
import net.sourceforge.jaxor.util.SystemException;

public class UnitOfWorkImpl
implements UnitOfWork {
    private final List _changes = new ArrayList();
    private boolean _committing = false;
    private int change;
    private boolean _batchingEnabled = false;

    private int getChange() {
        return this.change++;
    }

    public long size() {
        return this._changes.size();
    }

    public void registerUpdate(EntityInterface update) {
        EntityChange change = EntityChange.update(this.getChange(), update);
        if (this._committing) {
            update.update();
        } else {
            this._changes.add(change);
        }
    }

    public void registerNew(EntityInterface newEntity) {
        EntityChange change = EntityChange.insert(this.getChange(), newEntity);
        if (this._committing) {
            newEntity.insert();
        } else {
            this._changes.add(change);
        }
    }

    public int hashCode() {
        return this._changes.size();
    }

    public String toString() {
        return this._changes.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnitOfWorkImpl) {
            return this.equals((UnitOfWorkImpl)obj);
        }
        return false;
    }

    public boolean equals(UnitOfWorkImpl work) {
        return this._changes.equals(work._changes);
    }

    public void batching(boolean isEnabled) {
        this._batchingEnabled = isEnabled;
    }

    public void flush(Connection connection) {
        if (this._changes.size() == 0) {
            return;
        }
        try {
            this._committing = true;
            Iterator iterator = this._changes.iterator();
            while (iterator.hasNext()) {
                EntityChange entityChange = (EntityChange)iterator.next();
                entityChange.beforeFlush();
            }
            CommitBatch batch = new CommitBatch(this._changes);
            try {
                batch.execute(connection, this._batchingEnabled);
            }
            catch (SQLException e) {
                throw new SystemException(e);
            }
            Iterator iterator2 = this._changes.iterator();
            while (iterator2.hasNext()) {
                EntityChange entityChange = (EntityChange)iterator2.next();
                entityChange.afterFlush();
            }
            this._changes.clear();
            Object var7_7 = null;
            this._committing = false;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this._committing = false;
            throw throwable;
        }
    }

    public void registerDelete(EntityInterface ent) {
        this._changes.add(EntityChange.delete(this.getChange(), ent));
    }
}

