/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sourceforge.jaxor.parser.EntityCollection;
import net.sourceforge.jaxor.parser.EntityParser;
import net.sourceforge.jaxor.parser.Generator;
import net.sourceforge.jaxor.parser.GeneratorConfig;
import net.sourceforge.jaxor.parser.ImplParser;
import net.sourceforge.jaxor.parser.Jaxor;
import net.sourceforge.jaxor.parser.SourceMap;
import net.sourceforge.jaxor.util.SystemException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogSystem;
import org.xml.sax.EntityResolver;

public class AntTask
extends MatchingTask
implements LogSystem {
    private List _xmlFiles = new ArrayList();
    private File _destdir;
    private File _configFile;
    private File _mapperRegistry;
    private int _logLevel = 2;
    private XMLCatalog xmlCatalog = new XMLCatalog();
    private List _implParsers = new ArrayList();
    private boolean _validating = false;

    public void init() throws BuildException {
        super.init();
        this.xmlCatalog.setProject(this.getProject());
    }

    public void addConfiguredXMLCatalog(XMLCatalog xmlCatalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(xmlCatalog);
    }

    public void setValidating(boolean validate) {
        this._validating = validate;
    }

    public void setLogLevel(int level) {
        this._logLevel = level;
    }

    public File getMappers() {
        return this._mapperRegistry;
    }

    public void setMappers(File _mapperRegistry) {
        this._mapperRegistry = _mapperRegistry;
    }

    private Properties getMapperProps() {
        Properties props = new Properties();
        if (this.getMappers() == null) {
            return props;
        }
        try {
            props.load(new FileInputStream(this.getMappers()));
            return props;
        }
        catch (IOException e) {
            throw new SystemException(e);
        }
    }

    public void addImpl(ImplParser implParser) {
        this._implParsers.add(implParser);
    }

    public void addConfiguredFileset(FileSet fs) {
        this._xmlFiles.add(fs);
    }

    public File getDestdir() {
        return this._destdir;
    }

    public void setDestdir(File destdir) {
        this._destdir = destdir;
    }

    public void setConfigFile(File config) {
        this._configFile = config;
    }

    public File getConfigFile() {
        return this._configFile;
    }

    public void execute() {
        if (this._xmlFiles.size() == 0) {
            throw new BuildException("Not filesets specified");
        }
        SourceMap javaDocs = new SourceMap();
        Iterator iterator = this._implParsers.iterator();
        while (iterator.hasNext()) {
            ImplParser implParser = (ImplParser)iterator.next();
            javaDocs.put(implParser.findSource(this.getProject()));
        }
        int i = 0;
        while (i < this._xmlFiles.size()) {
            FileSet fs = (FileSet)this._xmlFiles.get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
            String[] srcFiles = ds.getIncludedFiles();
            this.parseFiles(srcFiles, ds.getBasedir(), javaDocs);
            ++i;
        }
    }

    public void init(RuntimeServices runtimeServices) throws Exception {
    }

    public void logVelocityMessage(int i, String s) {
        if (i >= this._logLevel) {
            this.log(s, i);
        }
    }

    public void parseFiles(String[] files, File srcDir, SourceMap javaDocBuilders) {
        EntityCollection collection = new EntityCollection(this.parseGenerator(), javaDocBuilders, this.getMapperProps());
        int i = 0;
        while (i < files.length) {
            String src = srcDir.getPath() + File.separator + files[i];
            try {
                EntityParser parser = new EntityParser(src, (EntityResolver)this.xmlCatalog);
                parser.run(this._validating);
                Jaxor j = parser.getJaxor();
                j.setSource(src);
                collection.add(j);
            }
            catch (Exception e) {
                throw new SystemException("Parsing Failed for file: " + new File(src), (Throwable)e);
            }
            ++i;
        }
        collection.generate(this._destdir, this);
    }

    private Generator parseGenerator() {
        File configFile = this.getConfigFile();
        if (configFile == null) {
            return Generator.createDefault();
        }
        Generator config = GeneratorConfig.getParser(configFile);
        return config;
    }
}

