/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.parser;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.sourceforge.jaxor.parser.ParseException;
import net.sourceforge.jaxor.parser.XmlProxy;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class DynamicParser
extends DefaultHandler {
    private final Stack _stack = new Stack();
    private Map _aliasMap = new HashMap();
    private XmlProxy _root;
    private Locator _locator = new LocatorImpl();

    public DynamicParser(Object root) {
        this._root = new XmlProxy(root, this._locator);
        this._stack.push(this._root);
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this._locator = locator;
    }

    public void addAlias(String alias, Class cl) {
        this._aliasMap.put(alias.toLowerCase(), cl);
    }

    public void startElement(String s, String s1, String name, Attributes attributes) throws SAXException {
        Object object = this.findObject(name);
        XmlProxy proxy = new XmlProxy(object, this._locator);
        proxy.setAll(attributes);
        this._stack.push(proxy);
    }

    public void characters(char[] chars, int i, int i1) throws SAXException {
        String s = new String(chars, i, i1).trim();
        if (s.length() == 0) {
            return;
        }
        XmlProxy proxy = (XmlProxy)this._stack.peek();
        proxy.add("CharacterData", new String(chars, i, i1));
    }

    public void endElement(String s, String s1, String name) throws SAXException {
        XmlProxy xmlElement = (XmlProxy)this._stack.pop();
        XmlProxy xml = (XmlProxy)this._stack.peek();
        xml.setElement(xmlElement.getObject(), name);
    }

    private Object findObject(String s) {
        Class toker = (Class)this._aliasMap.get(s.toLowerCase());
        if (toker != null) {
            return this.createInstance(toker);
        }
        XmlProxy xmlProxy = (XmlProxy)this._stack.peek();
        Object object = xmlProxy.getObject();
        Method[] methods = object.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            String name;
            Method method = methods[i];
            Class<?>[] params = method.getParameterTypes();
            if (params.length == 1 && (name = DynamicParser.getNameFromClass(params[0])).equalsIgnoreCase(s)) {
                return this.createInstance(params[0]);
            }
            ++i;
        }
        throw new ParseException("Unknown Element: " + s, this._locator);
    }

    private Object createInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new ParseException(e, this._locator);
        }
        catch (IllegalAccessException e) {
            throw new ParseException(e, this._locator);
        }
    }

    public static String getNameFromClass(Class clazz) {
        return clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1);
    }
}

