/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jaxor.parser.Aggregate;
import net.sourceforge.jaxor.parser.Attribute;
import net.sourceforge.jaxor.parser.AttributeList;
import net.sourceforge.jaxor.parser.Declarations;
import net.sourceforge.jaxor.parser.EntityCollection;
import net.sourceforge.jaxor.parser.EntityRef;
import net.sourceforge.jaxor.parser.Field;
import net.sourceforge.jaxor.parser.JMethod;
import net.sourceforge.jaxor.parser.JavaNameGenerator;
import net.sourceforge.jaxor.parser.Javadoc;
import net.sourceforge.jaxor.parser.Jaxor;
import net.sourceforge.jaxor.parser.ListRef;
import net.sourceforge.jaxor.parser.Param;
import net.sourceforge.jaxor.parser.PrimaryKey;
import net.sourceforge.jaxor.parser.Query;
import net.sourceforge.jaxor.util.SystemException;

public class Entity {
    private String _name;
    private List _attributes = new ArrayList();
    private String _alias;
    private String _extends;
    private String _implements;
    private String _select_all_sql = "";
    private List _aggregates = new ArrayList();
    private PrimaryKey _primaryKey;
    private String _list;
    private List _queries = new ArrayList();
    private List _fields = new ArrayList();
    private List _declarations = new ArrayList();
    private List _methods = new ArrayList();
    private List _foreignKeys = new ArrayList();
    private Javadoc _javadoc = null;
    private String _impl;
    private String _finder;

    public Entity(String name) {
        this._name = name;
    }

    public Entity() {
    }

    public void addJavadoc(Javadoc doc) {
        this._javadoc = doc;
    }

    public Javadoc getJavadoc() {
        return this._javadoc;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setImpl(String im) {
        this._impl = im;
    }

    public void setFinder(String finder) {
        this._finder = finder;
    }

    public String getImpl() {
        return this._impl;
    }

    public String getTableName() {
        return this._name;
    }

    public String getJavaName() {
        if (this._alias == null) {
            return JavaNameGenerator.toJavaName(this.getTableName());
        }
        return this._alias;
    }

    public String getListClass() {
        if (this._list == null) {
            return this.getGeneratedListName();
        }
        return this._list;
    }

    public String getRuntimeImpl() {
        if (this.getImpl() == null) {
            return this.getImplName();
        }
        return this.getImpl();
    }

    public String getGeneratedListName() {
        return this.getJavaName() + "List";
    }

    public String getIteratorName() {
        return this.getJavaName() + "Iterator";
    }

    public String getFinderImpl() {
        return this.getJavaName() + "FinderBase";
    }

    public String getFinder() {
        if (this._finder != null) {
            return this._finder;
        }
        return this.getFinderImpl();
    }

    public void setList(String l) {
        this._list = l;
    }

    public String getInterfaceName() {
        return this.getJavaName() + "Entity";
    }

    public String getReturnType() {
        return this.getInterfaceName();
    }

    public String getEntityRowName() {
        return this.getJavaName() + "EntityRow";
    }

    public String getFinderName() {
        return this.getJavaName() + "Finder";
    }

    public String getEntityResultSetClass() {
        return this.getJavaName() + "ResultSet";
    }

    public String getEntityQueryResultClass() {
        return this.getJavaName() + "Query";
    }

    public String getMetaName() {
        return this.getJavaName() + "MetaRow";
    }

    public String getImplName() {
        return this.getJavaName() + "Base";
    }

    public void setSelectAllSql(String s) {
        this._select_all_sql = s;
    }

    public String getSelectAllSql() {
        return this._select_all_sql;
    }

    public void addAttribute(Attribute attribute) {
        this._attributes.add(attribute);
    }

    public void addEntityRef(EntityRef f) {
        this._foreignKeys.add(f);
    }

    public void addPrimaryKey(PrimaryKey key) {
        if (this._primaryKey != null) {
            throw new SystemException("Can only define one Primary Key Set");
        }
        this._primaryKey = key;
    }

    public PrimaryKey getPrimaryKey() {
        return this._primaryKey;
    }

    public List getAttributesAndPrimaryKeys() {
        ArrayList all = new ArrayList();
        all.addAll(this._attributes);
        all.addAll(this._primaryKey.getKeys());
        return all;
    }

    public AttributeList getAttributeList() {
        return new AttributeList(this.getAttributes());
    }

    public List getAttributes() {
        ArrayList all = new ArrayList();
        all.addAll(this._attributes);
        all.addAll(this._primaryKey.getKeys());
        Iterator iterator = this._aggregates.iterator();
        while (iterator.hasNext()) {
            Aggregate aggregate = (Aggregate)iterator.next();
            all.addAll(aggregate.getAttributes());
        }
        return Collections.unmodifiableList(all);
    }

    public boolean hasPrimaryKey() {
        return this.getAttributeList().getPrimaryKey().size() > 0;
    }

    public Query getSelectByPrimaryKey(Jaxor j) {
        List attr = this.getAttributeList().getPrimaryKey();
        String name = "selectBy";
        Iterator iterator = attr.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            name = name + attribute.getJavaName();
            if (!iterator.hasNext()) continue;
            name = name + "And";
        }
        Query query = new Query(name, "");
        Iterator iterator2 = attr.iterator();
        while (iterator2.hasNext()) {
            Attribute attribute = (Attribute)iterator2.next();
            Param param = new Param(attribute, j);
            query.addParam(param);
        }
        return query;
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public void setExtends(String extendsOverride) {
        this._extends = extendsOverride;
    }

    public String getExtends() {
        return this._extends;
    }

    public void setImplements(String implementsOverride) {
        this._implements = implementsOverride;
    }

    public String getImplements() {
        return this._implements;
    }

    public List getAggregates() {
        return this._aggregates;
    }

    public void addAggregate(Aggregate aggregate) {
        this._aggregates.add(aggregate);
    }

    public List getForeignFields(EntityCollection coll, Jaxor jaxor) {
        return new ArrayList(this._foreignKeys);
    }

    public List getFields(EntityCollection coll, Jaxor j) {
        ArrayList results = new ArrayList(this._fields);
        return results;
    }

    public void addListRef(ListRef ref) {
        this._foreignKeys.add(ref);
    }

    public void addField(Field f) {
        this._fields.add(f);
    }

    public void addQuery(Query q) {
        this._queries.add(q);
    }

    public void addMethod(JMethod m) {
        this._methods.add(m);
    }

    public List getMethods() {
        return Collections.unmodifiableList(this._methods);
    }

    public void addDeclarations(Declarations d) {
        this._declarations.add(d);
    }

    public List getQueries(Jaxor j) {
        ArrayList allQueries = new ArrayList();
        allQueries.addAll(this._queries);
        allQueries.addAll(this.createQueriesForAttributes(j));
        return allQueries;
    }

    private List createQueriesForAttributes(Jaxor j) {
        ArrayList<Query> results = new ArrayList<Query>();
        List attr = this.getAttributeList().asList();
        Iterator iterator = attr.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            String sqlClause = "where " + attribute.getName() + "=?";
            Query query = new Query("selectBy" + attribute.getJavaName(), sqlClause);
            Param param = new Param(attribute, j);
            param.setMapper(attribute.getMapperName(j));
            query.addParam(param);
            results.add(query);
        }
        return results;
    }

    public List getDeclarations() {
        return Collections.unmodifiableList(this._declarations);
    }

    public Attribute findAttribute(String key) {
        return this.getAttributeList().findAttribute(key);
    }

    public List getEntityRefs() {
        return this._foreignKeys;
    }
}

