/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sourceforge.jaxor.parser.Generator;
import net.sourceforge.jaxor.parser.Jaxor;
import net.sourceforge.jaxor.parser.SourceMap;
import net.sourceforge.jaxor.util.SystemException;
import org.apache.velocity.runtime.log.LogSystem;

public class EntityCollection {
    private final List _jaxorList = new ArrayList();
    private final Generator _generator;
    private final SourceMap _javadocBuilders;
    private final Properties _mapperProps;

    public EntityCollection(Generator generator, SourceMap javaDocBuilders, Properties mapperProps) {
        this._generator = generator;
        this._javadocBuilders = javaDocBuilders;
        this._mapperProps = mapperProps;
    }

    public void add(Jaxor j) {
        this._jaxorList.add(j);
    }

    public void generate(File _destDir, LogSystem logger) {
        Iterator iterator = this._jaxorList.iterator();
        while (iterator.hasNext()) {
            Jaxor j = (Jaxor)iterator.next();
            j.setDestDir(_destDir);
            j.setConfig(this._generator);
            j.setMapperProps(this._mapperProps);
            j.setJavaDocBuilders(this._javadocBuilders);
            try {
                j.execute(this, logger);
            }
            catch (Exception e) {
                throw new SystemException("Failed Generating: " + j.getFullName(), (Throwable)e);
            }
        }
    }

    public Jaxor resolveEntity(String entity) {
        Jaxor result = null;
        Iterator iterator = this._jaxorList.iterator();
        while (iterator.hasNext()) {
            Jaxor jaxor = (Jaxor)iterator.next();
            if (!jaxor.getEntity().getTableName().equalsIgnoreCase(entity) && !jaxor.getFullName().equalsIgnoreCase(entity)) continue;
            if (result != null) {
                throw new SystemException("Multiple entities were found for: " + entity + " Please use fully qualifed package name.");
            }
            result = jaxor;
        }
        if (result != null) {
            return result;
        }
        throw new SystemException("Entity not found: " + entity);
    }

    public Jaxor find(String fullEntityName) {
        Iterator iterator = this._jaxorList.iterator();
        while (iterator.hasNext()) {
            Jaxor jaxor = (Jaxor)iterator.next();
            String fullName = jaxor.getFullName();
            if (!fullName.equalsIgnoreCase(fullEntityName)) continue;
            return jaxor;
        }
        return null;
    }
}

