/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.parser;

import java.util.StringTokenizer;
import net.sourceforge.jaxor.parser.DynamicParser;
import net.sourceforge.jaxor.parser.ParseException;
import net.sourceforge.jaxor.util.JavaBean;
import net.sourceforge.jaxor.util.MethodNotFound;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class XmlProxy {
    private final JavaBean _obj;
    private final Locator _locator;

    public XmlProxy(Object obj, Locator locator) {
        this._obj = new JavaBean(obj);
        this._locator = locator;
    }

    public void setAll(Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            String key = attributes.getQName(i);
            String value = attributes.getValue(i);
            this.set(key, value);
            ++i;
        }
    }

    public void add(String name, String value) {
        this._obj.add(name, value);
    }

    public void set(String name, String value) {
        this._obj.set(XmlProxy.getJavaName(name), value);
    }

    private static String getJavaName(String s) {
        String res = null;
        int idx = s.indexOf("-");
        if (idx != -1) {
            StringBuffer buf = new StringBuffer();
            StringTokenizer tokenizer = new StringTokenizer(s, "-");
            if (tokenizer.hasMoreTokens()) {
                buf.append(tokenizer.nextToken());
            }
            while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                char c0 = tok.charAt(0);
                String s2 = tok.substring(1);
                buf.append(Character.toUpperCase(c0));
                buf.append(s2);
            }
            res = buf.toString();
        } else {
            res = s;
        }
        return res;
    }

    public Object getObject() {
        return this._obj.getWrappedObject();
    }

    public void setElement(Object object, String name) {
        try {
            this._obj.add(name, object);
            return;
        }
        catch (MethodNotFound e) {
            try {
                this._obj.add(DynamicParser.getNameFromClass(object.getClass()), object);
                return;
            }
            catch (MethodNotFound methodNotFound) {
                throw new ParseException("Failed to set element: " + name + " on object: " + this.getObject(), this._locator);
            }
        }
    }
}

