/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sourceforge.jaxor.JaxorSession;
import net.sourceforge.jaxor.api.JaxorContext;
import net.sourceforge.jaxor.api.JaxorContextFactory;
import net.sourceforge.jaxor.api.JaxorTransaction;
import net.sourceforge.jaxor.util.SystemException;

public class JaxorFilter
implements Filter {
    private JaxorContextFactory _factory;

    public void init(FilterConfig config) throws ServletException {
        this._factory = this.loadFactory(config);
    }

    public void setContextFactory(JaxorContextFactory fact) {
        this._factory = fact;
    }

    private JaxorContextFactory loadFactory(FilterConfig config) {
        try {
            String factory = config.getInitParameter("factory");
            return (JaxorContextFactory)this.getClass().getClassLoader().loadClass(factory).newInstance();
        }
        catch (InstantiationException e) {
            throw new SystemException(e);
        }
        catch (IllegalAccessException e) {
            throw new SystemException(e);
        }
        catch (ClassNotFoundException e) {
            throw new SystemException(e);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        JaxorSession.setJaxorContext(this._factory.create());
        try {
            try {
                chain.doFilter(request, response);
                JaxorSession.commit();
            }
            catch (IOException e) {
                this.rollback(e);
                throw e;
            }
            catch (ServletException e) {
                this.rollback(e);
                throw e;
            }
            catch (RuntimeException e) {
                this.rollback(e);
                throw e;
            }
            Object var8_4 = null;
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            JaxorSession.end();
            throw throwable;
        }
        JaxorSession.end();
    }

    private void rollback(Exception e) {
        JaxorContext jaxorConnection = JaxorSession.getJaxorContext();
        if (jaxorConnection == null) {
            return;
        }
        JaxorTransaction transaction = jaxorConnection.getTransaction();
        if (transaction != null) {
            transaction.rollback(e);
        }
    }
}

