/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.sourceforge.jaxor.QueryParams;
import net.sourceforge.jaxor.api.EntityInterface;
import net.sourceforge.jaxor.api.QueryCache;

public class MethodCache
implements QueryCache {
    private transient Map _cacheByClass = MethodCache.createMap();
    public static boolean USE_WEAK_REFERENCES = true;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._cacheByClass = MethodCache.createMap();
    }

    private static Map createMap() {
        if (USE_WEAK_REFERENCES) {
            return new WeakHashMap();
        }
        return new HashMap();
    }

    public List get(Class clzz, String method, QueryParams param) {
        Map paramCache = this.getMethodCache(clzz, method);
        return (List)paramCache.get(param);
    }

    public void put(Class cl, String method, QueryParams param, List result) {
        Map paramCache = this.getMethodCache(cl, method);
        paramCache.put(param, result);
    }

    private Map getMethodCache(Class cl, String method) {
        Map classMethodCache = this.getClassCache(cl);
        Map methodCache = (Map)classMethodCache.get(method);
        if (methodCache == null) {
            methodCache = MethodCache.createMap();
            classMethodCache.put(method, methodCache);
        }
        return methodCache;
    }

    private Map getClassCache(Class clzz) {
        Map val = (Map)this._cacheByClass.get(clzz);
        if (val == null) {
            val = MethodCache.createMap();
            this._cacheByClass.put(clzz, val);
        }
        return val;
    }

    public void remove(EntityInterface abstractEntity) {
        Iterator iter = this._cacheByClass.values().iterator();
        while (iter.hasNext()) {
            Map classCache = (Map)iter.next();
            Iterator caches = classCache.values().iterator();
            while (caches.hasNext()) {
                Map methodCache = (Map)caches.next();
                Iterator methodIt = methodCache.values().iterator();
                while (methodIt.hasNext()) {
                    List list = (List)methodIt.next();
                    list.remove(abstractEntity);
                }
            }
        }
    }

    public void clear(Class aClass) {
        this._cacheByClass.remove(aClass);
    }

    public void clear() {
        this._cacheByClass.clear();
    }
}

