/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaxor.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SystemException
extends RuntimeException {
    private List _causes = new ArrayList();
    private String _stackTrace;

    public SystemException() {
    }

    public SystemException(String msg) {
        super(msg);
    }

    public SystemException(Throwable cause) {
        this("", cause);
    }

    public SystemException(String msg, Throwable cause) {
        super(msg);
        this._causes.add(cause);
    }

    public SystemException(Throwable root, Throwable secondary) {
        this("", root);
        this.add(secondary);
    }

    public void add(Throwable secondary) {
        this._causes.add(secondary);
    }

    private void getStackTraceAsString() {
        if (this._stackTrace != null) {
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printer = new PrintWriter(stringWriter);
        super.printStackTrace(printer);
        Iterator iterator = this._causes.iterator();
        while (iterator.hasNext()) {
            Throwable throwable = (Throwable)iterator.next();
            printer.println("Cause: ");
            throwable.printStackTrace(printer);
        }
        printer.flush();
        printer.close();
        this._stackTrace = stringWriter.getBuffer().toString();
    }

    public List getCauseList() {
        return this._causes;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream out) {
        this.getStackTraceAsString();
        try {
            ((FilterOutputStream)out).write(this._stackTrace.getBytes());
        }
        catch (IOException e) {
            throw new SystemException("Failed to write stack trace to stream", (Throwable)e);
        }
    }

    public void printStackTrace(PrintWriter out) {
        this.getStackTraceAsString();
        out.write(this._stackTrace);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.getStackTraceAsString();
        s.defaultWriteObject();
    }
}

