/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileListener;
import org.apache.commons.vfs.FileMonitor;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class DefaultFileMonitor
implements Runnable,
FileMonitor {
    private static final Log log = LogFactory.getLog(class$org$apache$commons$vfs$impl$DefaultFileMonitor == null ? (class$org$apache$commons$vfs$impl$DefaultFileMonitor = DefaultFileMonitor.class$("org.apache.commons.vfs.impl.DefaultFileMonitor")) : class$org$apache$commons$vfs$impl$DefaultFileMonitor);
    private final Map monitorMap = new HashMap();
    private Thread monitorThread;
    private Stack deleteStack = new Stack();
    private Stack addStack = new Stack();
    private boolean shouldRun = true;
    private boolean recursive = false;
    private long delay = 1000L;
    private final FileListener listener;
    static /* synthetic */ Class class$org$apache$commons$vfs$impl$DefaultFileMonitor;

    public DefaultFileMonitor(FileListener listener) {
        this.listener = listener;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean newRecursive) {
        this.recursive = newRecursive;
    }

    FileListener getFileListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(FileObject file) {
        Map map = this.monitorMap;
        synchronized (map) {
            if (this.monitorMap.get(file.getName()) == null) {
                this.monitorMap.put(file.getName(), new FileMonitorAgent(this, file));
                try {
                    if (this.listener != null) {
                        file.getFileSystem().addListener(file, this.listener);
                    }
                    if (file.getType().hasChildren() && this.recursive) {
                        FileObject[] children = file.getChildren();
                        for (int i = 0; i < children.length; ++i) {
                            this.addFile(children[i]);
                        }
                    }
                }
                catch (FileSystemException fse) {
                    log.error(fse.getLocalizedMessage(), fse);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(FileObject file) {
        Map map = this.monitorMap;
        synchronized (map) {
            FileName fn = file.getName();
            if (this.monitorMap.get(fn) != null) {
                FileMonitorAgent parentAgent;
                FileObject parent;
                try {
                    parent = file.getParent();
                }
                catch (FileSystemException fse) {
                    parent = null;
                }
                this.monitorMap.remove(fn);
                if (parent != null && (parentAgent = (FileMonitorAgent)this.monitorMap.get(parent.getName())) != null) {
                    parentAgent.resetChildrenList();
                }
            }
        }
    }

    protected void queueRemoveFile(FileObject file) {
        this.deleteStack.push(file);
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    protected void queueAddFile(FileObject file) {
        this.addStack.push(file);
    }

    public void start() {
        if (this.monitorThread == null) {
            this.monitorThread = new Thread(this);
            this.monitorThread.setDaemon(true);
            this.monitorThread.setPriority(1);
        }
        this.monitorThread.start();
    }

    public void stop() {
        this.shouldRun = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block8: while (!Thread.currentThread().isInterrupted() && this.shouldRun) {
            Object[] fileNames;
            while (!this.deleteStack.empty()) {
                this.removeFile((FileObject)this.deleteStack.pop());
            }
            Map map = this.monitorMap;
            synchronized (map) {
                fileNames = this.monitorMap.keySet().toArray();
            }
            for (int iterFileNames = 0; iterFileNames < fileNames.length; ++iterFileNames) {
                FileMonitorAgent agent;
                FileName fileName = (FileName)fileNames[iterFileNames];
                Map map2 = this.monitorMap;
                synchronized (map2) {
                    agent = (FileMonitorAgent)this.monitorMap.get(fileName);
                }
                if (agent != null) {
                    agent.check();
                }
                if (Thread.currentThread().isInterrupted() || !this.shouldRun) continue block8;
            }
            while (!this.addStack.empty()) {
                this.addFile((FileObject)this.addStack.pop());
            }
            try {
                Thread.sleep(this.getDelay());
            }
            catch (InterruptedException e) {}
        }
        this.shouldRun = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FileMonitorAgent {
        private final FileObject file;
        private final DefaultFileMonitor fm;
        private boolean exists;
        private long timestamp;
        private Map children = null;

        private FileMonitorAgent(DefaultFileMonitor fm, FileObject file) {
            this.fm = fm;
            this.file = file;
            this.refresh();
            this.resetChildrenList();
            try {
                this.exists = this.file.exists();
            }
            catch (FileSystemException fse) {
                this.exists = false;
            }
            try {
                this.timestamp = this.file.getContent().getLastModifiedTime();
            }
            catch (FileSystemException fse) {
                this.timestamp = -1L;
            }
        }

        private void resetChildrenList() {
            try {
                if (this.file.getType() == FileType.FOLDER) {
                    this.children = new HashMap();
                    FileObject[] childrenList = this.file.getChildren();
                    for (int i = 0; i < childrenList.length; ++i) {
                        this.children.put(childrenList[i].getName(), new Object());
                    }
                }
            }
            catch (FileSystemException fse) {
                this.children = null;
            }
        }

        private void refresh() {
            try {
                this.file.close();
            }
            catch (FileSystemException fse) {
                log.error(fse.getLocalizedMessage(), fse);
            }
        }

        private void fireAllCreate(FileObject child) {
            if (this.fm.getFileListener() != null) {
                child.getFileSystem().addListener(child, this.fm.getFileListener());
            }
            ((AbstractFileSystem)child.getFileSystem()).fireFileCreated(child);
            if (this.fm.getFileListener() != null) {
                child.getFileSystem().removeListener(child, this.fm.getFileListener());
            }
            this.fm.queueAddFile(child);
            try {
                if (this.fm.isRecursive() && child.getType() == FileType.FOLDER) {
                    FileObject[] newChildren = child.getChildren();
                    for (int i = 0; i < newChildren.length; ++i) {
                        this.fireAllCreate(newChildren[i]);
                    }
                }
            }
            catch (FileSystemException fse) {
                log.error(fse.getLocalizedMessage(), fse);
            }
        }

        private void checkForNewChildren() {
            try {
                if (this.file.getType() == FileType.FOLDER) {
                    FileObject[] newChildren = this.file.getChildren();
                    if (this.children != null) {
                        HashMap<FileName, Object> newChildrenMap = new HashMap<FileName, Object>();
                        Stack<FileObject> missingChildren = new Stack<FileObject>();
                        for (int i = 0; i < newChildren.length; ++i) {
                            newChildrenMap.put(newChildren[i].getName(), new Object());
                            if (this.children.containsKey(newChildren[i].getName())) continue;
                            missingChildren.push(newChildren[i]);
                        }
                        this.children = newChildrenMap;
                        if (!missingChildren.empty()) {
                            while (!missingChildren.empty()) {
                                FileObject child = (FileObject)missingChildren.pop();
                                this.fireAllCreate(child);
                            }
                        }
                    } else {
                        if (newChildren.length > 0) {
                            this.children = new HashMap();
                        }
                        for (int i = 0; i < newChildren.length; ++i) {
                            this.children.put(newChildren[i].getName(), new Object());
                            this.fireAllCreate(newChildren[i]);
                        }
                    }
                }
            }
            catch (FileSystemException fse) {
                log.error(fse.getLocalizedMessage(), fse);
            }
        }

        private void check() {
            this.refresh();
            try {
                if (this.exists && !this.file.exists()) {
                    this.exists = this.file.exists();
                    this.timestamp = -1L;
                    ((AbstractFileSystem)this.file.getFileSystem()).fireFileDeleted(this.file);
                    if (this.fm.getFileListener() != null) {
                        this.file.getFileSystem().removeListener(this.file, this.fm.getFileListener());
                    }
                    this.fm.queueRemoveFile(this.file);
                } else if (this.exists && this.file.exists() && this.timestamp != this.file.getContent().getLastModifiedTime()) {
                    this.timestamp = this.file.getContent().getLastModifiedTime();
                    if (this.file.getType() != FileType.FOLDER) {
                        ((AbstractFileSystem)this.file.getFileSystem()).fireFileChanged(this.file);
                    }
                }
                this.checkForNewChildren();
            }
            catch (FileSystemException fse) {
                log.error(fse.getLocalizedMessage(), fse);
            }
        }
    }
}

