/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileListener;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.FilesCache;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.events.AbstractFileChangeEvent;
import org.apache.commons.vfs.events.ChangedEvent;
import org.apache.commons.vfs.events.CreateEvent;
import org.apache.commons.vfs.events.DeleteEventAbstractFile;
import org.apache.commons.vfs.provider.AbstractVfsComponent;
import org.apache.commons.vfs.provider.FileSystemKey;
import org.apache.commons.vfs.util.Messages;

public abstract class AbstractFileSystem
extends AbstractVfsComponent
implements FileSystem {
    private static final Log log = LogFactory.getLog(class$org$apache$commons$vfs$provider$AbstractFileSystem == null ? (class$org$apache$commons$vfs$provider$AbstractFileSystem = AbstractFileSystem.class$("org.apache.commons.vfs.provider.AbstractFileSystem")) : class$org$apache$commons$vfs$provider$AbstractFileSystem);
    private final FileName rootName;
    private FileObject parentLayer;
    private final Collection caps = new HashSet();
    private FilesCache files;
    private final Map listenerMap = new HashMap();
    private final FileSystemOptions fileSystemOptions;
    private long useCount;
    private FileSystemKey cacheKey;
    static /* synthetic */ Class class$org$apache$commons$vfs$provider$AbstractFileSystem;

    protected AbstractFileSystem(FileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) {
        this.parentLayer = parentLayer;
        this.rootName = rootName;
        this.fileSystemOptions = fileSystemOptions;
        this.files = null;
    }

    public void init() throws FileSystemException {
        this.addCapabilities(this.caps);
    }

    public void close() {
        this.closeCommunicationLink();
        this.parentLayer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeCommunicationLink() {
        AbstractFileSystem abstractFileSystem = this;
        synchronized (abstractFileSystem) {
            this.doCloseCommunicationLink();
        }
    }

    protected void doCloseCommunicationLink() {
    }

    protected abstract FileObject createFile(FileName var1) throws Exception;

    protected abstract void addCapabilities(Collection var1);

    public FileName getRootName() {
        return this.rootName;
    }

    protected void putFileToCache(FileObject file) {
        this.getCache().putFile(file);
    }

    private FilesCache getCache() {
        if (this.files == null) {
            this.files = this.getContext().getFileSystemManager().getFilesCache();
            if (this.files == null) {
                throw new RuntimeException(Messages.getString("vfs.provider/files-cache-missing.error"));
            }
        }
        return this.files;
    }

    protected FileObject getFileFromCache(FileName name) {
        return this.getCache().getFile(this, name);
    }

    protected void removeFileFromCache(FileName name) {
        this.getCache().removeFile(this, name);
    }

    public boolean hasCapability(Capability capability) {
        return this.caps.contains(capability);
    }

    public Object getAttribute(String attrName) throws FileSystemException {
        throw new FileSystemException("vfs.provider/get-attribute-not-supported.error");
    }

    public void setAttribute(String attrName, Object value) throws FileSystemException {
        throw new FileSystemException("vfs.provider/set-attribute-not-supported.error");
    }

    public FileObject getParentLayer() throws FileSystemException {
        return this.parentLayer;
    }

    public FileObject getRoot() throws FileSystemException {
        return this.resolveFile(this.rootName);
    }

    public FileObject resolveFile(String nameStr) throws FileSystemException {
        FileName name = this.rootName.resolveName(nameStr);
        return this.resolveFile(name);
    }

    public synchronized FileObject resolveFile(FileName name) throws FileSystemException {
        return this.resolveFile(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized FileObject resolveFile(FileName name, boolean useCache) throws FileSystemException {
        if (!this.rootName.getRootURI().equals(name.getRootURI())) {
            throw new FileSystemException("vfs.provider/mismatched-fs-for-name.error", new Object[]{name, this.rootName});
        }
        FileObject file = useCache ? this.getFileFromCache(name) : null;
        if (file == null) {
            try {
                AbstractFileSystem abstractFileSystem = this;
                synchronized (abstractFileSystem) {
                    file = this.createFile(name);
                }
            }
            catch (Exception e) {
                throw new FileSystemException("vfs.provider/resolve-file.error", name, (Throwable)e);
            }
            if (useCache) {
                this.putFileToCache(file);
            }
        }
        return file;
    }

    public File replicateFile(FileObject file, FileSelector selector) throws FileSystemException {
        if (!file.exists()) {
            throw new FileSystemException("vfs.provider/replicate-missing-file.error", file.getName());
        }
        try {
            return this.doReplicateFile(file, selector);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/replicate-file.error", file.getName(), (Throwable)e);
        }
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    public FileSystemManager getFileSystemManager() {
        return this.getContext().getFileSystemManager();
    }

    public double getLastModTimeAccuracy() {
        return 0.0;
    }

    protected File doReplicateFile(FileObject file, FileSelector selector) throws Exception {
        return this.getContext().getReplicator().replicateFile(file, selector);
    }

    public void addJunction(String junctionPoint, FileObject targetFile) throws FileSystemException {
        throw new FileSystemException("vfs.provider/junctions-not-supported.error", this.rootName);
    }

    public void removeJunction(String junctionPoint) throws FileSystemException {
        throw new FileSystemException("vfs.provider/junctions-not-supported.error", this.rootName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FileObject file, FileListener listener) {
        Map map = this.listenerMap;
        synchronized (map) {
            ArrayList<FileListener> listeners = (ArrayList<FileListener>)this.listenerMap.get(file.getName());
            if (listeners == null) {
                listeners = new ArrayList<FileListener>();
                this.listenerMap.put(file.getName(), listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(FileObject file, FileListener listener) {
        Map map = this.listenerMap;
        synchronized (map) {
            ArrayList listeners = (ArrayList)this.listenerMap.get(file.getName());
            if (listeners != null) {
                listeners.remove(listener);
            }
        }
    }

    public void fireFileCreated(FileObject file) {
        this.fireEvent(new CreateEvent(file));
    }

    public void fireFileDeleted(FileObject file) {
        this.fireEvent(new DeleteEventAbstractFile(file));
    }

    public void fireFileChanged(FileObject file) {
        this.fireEvent(new ChangedEvent(file));
    }

    public boolean isReleaseable() {
        return this.useCount < 1L;
    }

    void freeResources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(AbstractFileChangeEvent event) {
        Map map = this.listenerMap;
        synchronized (map) {
            FileObject file = event.getFile();
            ArrayList listeners = (ArrayList)this.listenerMap.get(file.getName());
            if (listeners != null) {
                int count = listeners.size();
                for (int i = 0; i < count; ++i) {
                    FileListener listener = (FileListener)listeners.get(i);
                    try {
                        event.notify(listener);
                        continue;
                    }
                    catch (Exception e) {
                        String message = Messages.getString("vfs.provider/notify-listener.warn", file);
                        VfsLog.warn(this.getLogger(), log, message, e);
                    }
                }
            }
        }
    }

    void fileDetached(FileObject fileObject) {
        --this.useCount;
    }

    void fileAttached(FileObject fileObject) {
        ++this.useCount;
    }

    void setCacheKey(FileSystemKey cacheKey) {
        this.cacheKey = cacheKey;
    }

    FileSystemKey getCacheKey() {
        return this.cacheKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

