/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ftp;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.ftp.FtpFileSystemConfigBuilder;

public class FtpClientFactory {
    private FtpClientFactory() {
    }

    public static FTPClient createConnection(String hostname, int port, String username, String password, String workingDirectory, FileSystemOptions fileSystemOptions) throws FileSystemException {
        if (username == null) {
            username = "anonymous";
        }
        if (password == null) {
            password = "anonymous";
        }
        try {
            FTPClient client = new FTPClient();
            FTPFileEntryParserFactory myFactory = FtpFileSystemConfigBuilder.getInstance().getEntryParserFactory(fileSystemOptions);
            if (myFactory != null) {
                client.setParserFactory(myFactory);
            }
            try {
                client.connect(hostname, port);
                int reply = client.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)reply)) {
                    throw new FileSystemException("vfs.provider.ftp/connect-rejected.error", hostname);
                }
                if (!client.login(username, password)) {
                    throw new FileSystemException("vfs.provider.ftp/login.error", new Object[]{hostname, username}, null);
                }
                if (!client.setFileType(2)) {
                    throw new FileSystemException("vfs.provider.ftp/set-binary.error", hostname);
                }
                if (workingDirectory != null && !client.changeWorkingDirectory(workingDirectory)) {
                    throw new FileSystemException("vfs.provider/get-attributes-no-exist.error", "/");
                }
                Boolean passiveMode = FtpFileSystemConfigBuilder.getInstance().getPassiveMode(fileSystemOptions);
                if (passiveMode != null && passiveMode.booleanValue()) {
                    client.enterLocalPassiveMode();
                }
            }
            catch (IOException e) {
                if (client.isConnected()) {
                    client.disconnect();
                }
                throw e;
            }
            return client;
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider.ftp/connect.error", new Object[]{hostname}, (Throwable)exc);
        }
    }
}

